/*
 * Decompiled with CFR 0.152.
 */
package testcase;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import junit.framework.TestCase;
import net.java.sen.StringTagger;
import net.java.sen.Token;
import net.java.sen.processor.RemarkPostProcessor;
import net.java.sen.processor.RemarkPreProcessor;

public class RemarkProcessorTest
extends TestCase {
    public static String TESTSTR = "before&lt;\u30b3\u30e1\u30f3\u30c8&gt;after";

    public void testAnalyze() throws IllegalArgumentException, IOException {
        StringTagger tagger = StringTagger.getInstance("conf/sen-processor.xml");
        RemarkPostProcessor remarkPostPr = new RemarkPostProcessor();
        RemarkPreProcessor remarkPrePr = new RemarkPreProcessor();
        remarkPrePr.readRules(new BufferedReader(new StringReader("&lt; &gt; \u8a18\u53f7-\u6ce8\u91c8")));
        tagger.addPostProcessor(remarkPostPr);
        tagger.addPreProcessor(remarkPrePr);
        Token[] token = tagger.analyze(TESTSTR);
        RemarkProcessorTest.assertEquals((String)token[0].toString(), (String)"before");
        RemarkProcessorTest.assertEquals((String)"&lt;\u30b3\u30e1\u30f3\u30c8&gt;", (String)token[1].toString());
        RemarkProcessorTest.assertEquals((int)6, (int)token[1].start());
        RemarkProcessorTest.assertEquals((int)18, (int)token[1].end());
        RemarkProcessorTest.assertEquals((String)"\u8a18\u53f7-\u6ce8\u91c8", (String)token[1].getPos());
        RemarkProcessorTest.assertEquals((String)"after", (String)token[2].toString());
        RemarkProcessorTest.assertEquals((int)18, (int)token[2].start());
        RemarkProcessorTest.assertEquals((int)23, (int)token[2].end());
    }

    static {
        System.setProperty("sen.home", ".");
    }
}

