/*
 * Decompiled with CFR 0.152.
 */
package net.java.sen.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import net.java.sen.io.FileAccessor;

public class MappedBufferedReader
implements FileAccessor {
    byte[] buf;
    int pos = 0;
    long length = 0L;
    MappedByteBuffer map = null;
    FileInputStream fis = null;

    public MappedBufferedReader(String name) throws IOException {
        this(new File(name));
    }

    public MappedBufferedReader(File file) throws IOException {
        this.fis = new FileInputStream(file);
        FileChannel fc = this.fis.getChannel();
        this.length = fc.size();
        this.map = fc.map(FileChannel.MapMode.READ_ONLY, 0L, this.length);
    }

    public void seek(int pos) throws IOException {
        if (pos < 0 || (long)pos >= this.length) {
            throw new IOException("File position is invalid. File size is " + this.length + " but specified position is " + pos);
        }
        this.map.position(pos);
    }

    public void seek(long pos) throws IOException {
        if (pos < 0L || pos >= this.length) {
            throw new IOException("File position is invalid. File size is " + this.length + " but specified position is " + pos);
        }
        this.map.position((int)pos);
    }

    public short readShort() throws IOException {
        return this.map.getShort();
    }

    public int readInt() {
        return this.map.getInt();
    }

    public int read() {
        int b = this.map.get();
        return b >= 0 ? b : 256 + b;
    }

    public int read(byte[] b, int start, int length) {
        this.map.get(b, start, length);
        return length;
    }

    public void close() throws IOException {
        this.fis.close();
    }
}

