/*
 * Decompiled with CFR 0.152.
 */
package net.java.sen;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.java.sen.Node;
import net.java.sen.SenUtils;
import net.java.sen.Token;
import net.java.sen.Tokenizer;
import net.java.sen.Viterbi;
import net.java.sen.processor.PostProcessor;
import net.java.sen.processor.PreProcessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class StringTagger {
    private static Log log;
    private static HashMap hash;
    private Viterbi viterbi = null;
    private Node node = null;
    Token[] token = null;
    int cnt = 0;
    private static StringTagger tagger;
    private static String DEFAULT_CONFIG;
    protected String unknownPos = null;
    private List preProcessorList = new ArrayList();
    private List postProcessorList = new ArrayList();
    String tokenFile = null;
    String doubleArrayFile = null;
    String posInfoFile = null;
    String connectFile = null;
    String charset = null;
    String tokenizerClass = "net.java.sen.ja.JapaneseTokenizer";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.java.sen.StringTagger");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
        hash = new HashMap();
        tagger = null;
        DEFAULT_CONFIG = "conf/sen.xml";
    }

    private StringTagger(String senConfig) throws IOException, IllegalArgumentException {
        this.init(senConfig);
    }

    public static StringTagger getInstance() throws IllegalArgumentException, IOException {
        return StringTagger.getInstance(String.valueOf(System.getProperty("sen.home")) + System.getProperty("file.separator") + DEFAULT_CONFIG);
    }

    public static StringTagger getInstance(Locale locale) throws IOException, IllegalArgumentException {
        if (locale.equals(Locale.JAPANESE)) {
            return StringTagger.getInstance();
        }
        throw new IllegalArgumentException("Locale '" + locale.getDisplayName() + "' isn't supported.");
    }

    public static synchronized StringTagger getInstance(String senConfig) throws IOException, IllegalArgumentException {
        Object tagger = hash.get(senConfig);
        if (tagger == null) {
            tagger = new StringTagger(senConfig);
            hash.put(senConfig, tagger);
            return (StringTagger)tagger;
        }
        return (StringTagger)tagger;
    }

    private void init(String confFile) throws IOException {
        this.readConfig(confFile);
        Tokenizer tokenizer = null;
        try {
            Class<?> c = Class.forName(this.tokenizerClass);
            Class[] classArray = new Class[5];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[1] = clazz2;
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[2] = clazz3;
            Class<?> clazz4 = class$1;
            if (clazz4 == null) {
                try {
                    clazz4 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[3] = clazz4;
            Class<?> clazz5 = class$1;
            if (clazz5 == null) {
                try {
                    clazz5 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[4] = clazz5;
            Constructor<?> cons = c.getConstructor(classArray);
            tokenizer = (Tokenizer)cons.newInstance(this.tokenFile, this.doubleArrayFile, this.posInfoFile, this.connectFile, this.charset);
        }
        catch (Exception ce) {
            throw new IllegalArgumentException("Tokenizer Class: " + this.tokenizerClass + " is invalid.");
        }
        this.viterbi = new Viterbi(tokenizer);
    }

    /*
     * Unable to fully structure code
     */
    public synchronized Token[] analyze(String input) throws IOException {
        if (StringTagger.log.isDebugEnabled()) {
            StringTagger.log.debug((Object)("analyzer:" + input));
        }
        postProcessInfo = new HashMap<K, V>();
        input = this.doPreProcess(input, postProcessInfo);
        len = 0;
        iter = node = this.viterbi.analyze((char[])input.toCharArray()).next;
        if (node != null) ** GOTO lbl11
        return null;
lbl-1000:
        // 1 sources

        {
            ++len;
            iter = iter.next;
lbl11:
            // 2 sources

            ** while (iter.next != null)
        }
lbl12:
        // 1 sources

        this.token = new Token[len];
        i = 0;
        while (node.next != null) {
            this.token[i] = new Token(node);
            if (this.token[i].getPos() == null) {
                this.token[i].setPos(this.unknownPos);
            }
            ++i;
            node = node.next;
        }
        this.cnt = 0;
        this.token = this.doPostProcess(this.token, postProcessInfo);
        return this.token;
    }

    public Token next() {
        if (this.token == null && this.cnt == this.token.length) {
            return null;
        }
        return this.token[this.cnt++];
    }

    public boolean hasNext() {
        return this.token != null || this.cnt != this.token.length;
    }

    private void readConfig(String confFile) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            File cf = new File(confFile);
            String parent = cf.getParentFile().getParent();
            if (parent == null) {
                parent = ".";
            }
            Document doc = builder.parse(new InputSource("file://" + confFile));
            NodeList nl = doc.getFirstChild().getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                org.w3c.dom.Node n = nl.item(i);
                if (n.getNodeType() == 1) {
                    String nn = n.getNodeName();
                    String value = n.getFirstChild().getNodeValue();
                    if (nn.equals("charset")) {
                        this.charset = value;
                    } else if (nn.equals("unknown-pos")) {
                        this.unknownPos = value;
                    } else if (nn.equals("tokenizer")) {
                        this.tokenizerClass = value;
                    }
                    if (nn.equals("dictionary")) {
                        NodeList dnl = n.getChildNodes();
                        int j = 0;
                        while (j < dnl.getLength()) {
                            org.w3c.dom.Node dn = dnl.item(j);
                            if (dn.getNodeType() == 1) {
                                String dnn = dn.getNodeName();
                                if (dn.getFirstChild() == null) {
                                    throw new IllegalArgumentException("element '" + dnn + "' is empty");
                                }
                                String dvalue = dn.getFirstChild().getNodeValue();
                                if (dnn.equals("connection-cost")) {
                                    this.connectFile = SenUtils.getPath(dvalue, parent);
                                } else if (dnn.equals("double-array-trie")) {
                                    this.doubleArrayFile = SenUtils.getPath(dvalue, parent);
                                } else if (dnn.equals("token")) {
                                    this.tokenFile = SenUtils.getPath(dvalue, parent);
                                } else if (dnn.equals("pos-info")) {
                                    this.posInfoFile = SenUtils.getPath(dvalue, parent);
                                } else if (!dnn.equals("compound")) {
                                    throw new IllegalArgumentException("element '" + dnn + "' is invalid");
                                }
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
        catch (ParserConfigurationException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (SAXException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public void addPostProcessor(PostProcessor processor) {
        this.postProcessorList.add(processor);
    }

    public void addPreProcessor(PreProcessor processor) {
        this.preProcessorList.add(processor);
    }

    protected String doPreProcess(String input, Map postProcessInfo) {
        Iterator itr = this.preProcessorList.iterator();
        String i = input;
        while (itr.hasNext()) {
            PreProcessor p = (PreProcessor)itr.next();
            i = p.process(i, postProcessInfo);
        }
        return i;
    }

    protected Token[] doPostProcess(Token[] tokens, Map postProcessInfo) {
        Iterator itr = this.postProcessorList.iterator();
        Token[] newTokens = tokens;
        while (itr.hasNext()) {
            PostProcessor p = (PostProcessor)itr.next();
            newTokens = p.process(newTokens, postProcessInfo);
        }
        return newTokens;
    }
}

