/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.sen;

import java.io.File;
import java.io.IOException;
import jp.sourceforge.akjrcp.commons.plugin.PluginUtils;
import net.java.sen.StringTagger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SenTools {
    private static StringTagger stringTagger;
    public static Log log;

    static {
        log = LogFactory.getLog(SenTools.class);
    }

    public static StringTagger loadStringTagger() {
        File dir = PluginUtils.getPluginDir((String)"jp.sourceforge.akjrcp.lib.sen");
        if (dir == null) {
            log.warn((Object)"plugin:jp.sourceforge.akjrcp.lib.sen not found");
            return null;
        }
        return SenTools.loadStringTagger(dir);
    }

    public static StringTagger loadStringTagger(File pluginDir) {
        if (stringTagger != null) {
            return stringTagger;
        }
        log.info((Object)("Sen's pluginDir:" + pluginDir.getAbsolutePath()));
        File senConf = new File(pluginDir, "sen-1.2/conf/sen.xml");
        log.info((Object)("senConf-Path:" + senConf.getAbsolutePath()));
        try {
            String path = SenTools.toUnixPath(senConf.getAbsolutePath());
            log.info((Object)("unix-path:" + path));
            if (senConf.exists()) {
                stringTagger = StringTagger.getInstance((String)path);
            } else {
                log.warn((Object)("senConf-Not found:" + senConf.getAbsolutePath()));
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (stringTagger == null) {
            log.warn((Object)"stringTagger = null:");
        }
        return stringTagger;
    }

    private static String toUnixPath(String path) {
        if (!(path = path.replaceAll("\\\\", "/")).startsWith("/")) {
            return "/" + path;
        }
        return path;
    }
}

