/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.speech.multi;

import java.io.File;
import java.io.IOException;
import jp.sourceforge.akjrcp.sen.SenTools;
import jp.sourceforge.akjrcp.sen.StringTaggerControler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jpn.xucker.rcp.speech.gtalk.Gtalk;
import org.jpn.xucker.rcp.speech.views.JapaneseVoiceSettingView;
import org.jpn.xucker.speech.AlphaToKana;
import org.jpn.xucker.speech.multi.MultiTypeText;
import org.jpn.xucker.speech.multi.MultiTypeTextPlayer;

public class GtalkPlayer
implements MultiTypeTextPlayer {
    public static Log log = LogFactory.getLog(GtalkPlayer.class);
    private boolean enabled = true;
    private boolean readUS;
    private int maxlength = 55;
    private Gtalk gtalk = new Gtalk();
    private boolean convertPronounce;
    private String ESCAPE_SPACE = "__SSPPAACCEE__";
    private int maxKana = 60;

    public boolean isReadUS() {
        return this.readUS;
    }

    public void setReadUS(boolean readUS) {
        this.readUS = readUS;
    }

    public Gtalk getGtalk() {
        return this.gtalk;
    }

    public void setGtalk(Gtalk gtalk) {
        this.gtalk = gtalk;
    }

    @Override
    public boolean available(MultiTypeText text) {
        boolean ret = false;
        ret = this.readUS ? this.enabled && (text.getType().equals("jp") || text.getType().equals("us")) : this.enabled && text.getType().equals("jp");
        log.trace((Object)("" + ret));
        return ret;
    }

    @Override
    public void play(MultiTypeText text) {
        log.trace((Object)("play:" + text.getText()));
        String[] texts = null;
        try {
            if (text.getType().equals("us")) {
                String kana = AlphaToKana.toKane(text.getText());
                log.trace((Object)("kana='" + kana + "'"));
                texts = this.convertPronounce ? new StringTaggerControler(SenTools.loadStringTagger()).split(kana, 55, "pronunciation") : new StringTaggerControler(SenTools.loadStringTagger()).split(kana, 55, "base");
                log.trace((Object)("textlength:" + texts.length));
                this.gtalk.play(this.toTaggedText(texts));
            } else {
                texts = this.convertPronounce ? this.convertJPPronounceText(text) : this.convertJPText(text);
                this.gtalk.play(this.toTaggedText(texts));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String[] toTaggedText(String[] text) {
        JapaneseVoiceSettingView japaneseSetting = JapaneseVoiceSettingView.getDefaultView();
        if (japaneseSetting != null) {
            String[] returnText = new String[text.length];
            String header = japaneseSetting.getGtalkHeaderTag();
            String footer = japaneseSetting.getGtalkFooterTag();
            int i = 0;
            while (i < text.length) {
                returnText[i] = String.valueOf(header) + text[i] + footer;
                ++i;
            }
            return returnText;
        }
        return text;
    }

    private String[] convertJPPronounceText(MultiTypeText text) throws IOException {
        String[] texts = null;
        String newText = text.getText().replaceAll(" ", this.ESCAPE_SPACE);
        texts = new StringTaggerControler(SenTools.loadStringTagger()).split(newText, this.maxlength, "pronunciation");
        this.unescapeSpace(texts);
        return texts;
    }

    private String[] convertJPText(MultiTypeText text) {
        String[] texts = null;
        texts = new String[]{text.getText()};
        return texts;
    }

    public void unescapeSpace(String[] lines) {
        int i = 0;
        while (i < lines.length) {
            lines[i] = lines[i].replaceAll(this.ESCAPE_SPACE, " ");
            ++i;
        }
    }

    @Override
    public void write(MultiTypeText text, File file) {
        log.trace((Object)("write:" + text.getText()));
        String[] texts = null;
        try {
            if (text.getType().equals("us")) {
                String kana = AlphaToKana.toKane(text.getText());
                log.trace((Object)("kana='" + kana + "'"));
                texts = this.convertPronounce ? new StringTaggerControler(SenTools.loadStringTagger()).split(kana, 55, "pronunciation") : new StringTaggerControler(SenTools.loadStringTagger()).split(kana, 55, "base");
                log.trace((Object)("textlength:" + texts.length));
                this.gtalk.writeWav(this.toTaggedText(texts), file);
            } else {
                texts = this.convertPronounce ? this.convertJPPronounceText(text) : this.convertJPText(text);
                log.trace((Object)("textlength:" + texts.length));
                this.gtalk.writeWav(this.toTaggedText(texts), file);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void cancel() {
        this.gtalk.cancel();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean bool) {
        this.enabled = bool;
    }

    public String getGtalkBaseDir() {
        return this.gtalk.getGtalkBaseDir();
    }

    public String getGtalkSettringPath() {
        return this.gtalk.getGtalkSettringPath();
    }

    public void setGtalkBaseDir(String arg0) {
        this.gtalk.setGtalkBaseDir(arg0);
    }

    public void setGtalkSettringPath(String arg0) {
        this.gtalk.setGtalkSettringPath(arg0);
    }

    public boolean isConvertPronounce() {
        return this.convertPronounce;
    }

    public void setConvertPronounce(boolean convertPronounce) {
        this.convertPronounce = convertPronounce;
    }

    @Override
    public void dispose() {
        if (this.gtalk != null) {
            this.gtalk.dispose();
        }
    }
}

