/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.rcp.speech.wizards;

import java.io.IOException;
import java.util.HashMap;

public class FileNameUtils {
    public static char[] NON_FILENAME = new char[]{'\\', '/', ':', '*', '?', '<', '>', '|'};

    public static String replaceNonFileName(String base, String replaceText, int maxlength) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < base.length() && i < maxlength) {
            if (FileNameUtils.isNonFileNameChar(base.charAt(i))) {
                result.append(replaceText);
            } else {
                result.append(base.charAt(i));
            }
            ++i;
        }
        return result.toString();
    }

    public static boolean isNonFileNameChar(char ch) {
        int i = 0;
        while (i < NON_FILENAME.length) {
            if (NON_FILENAME[i] == ch) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String[] avoidSameName(String[] filenames, String[] otherNames) throws IOException {
        int i;
        int max = 999999;
        String[] result = new String[filenames.length];
        HashMap<String, String> map = new HashMap<String, String>();
        if (otherNames != null) {
            i = 0;
            while (i < otherNames.length) {
                map.put(otherNames[i], "");
                ++i;
            }
        }
        i = 0;
        while (i < result.length) {
            String newname = filenames[i];
            int last = filenames[i].lastIndexOf(".");
            String head = null;
            String foot = null;
            if (last != -1) {
                head = filenames[i].substring(0, last);
                foot = filenames[i].substring(last);
            } else {
                head = filenames[i];
                foot = "";
            }
            int sx = 1;
            while (map.get(newname) != null) {
                newname = String.valueOf(head) + "_" + sx + foot;
                if (++sx <= max) continue;
                throw new IOException("can't filename renamed");
            }
            result[i] = newname;
            map.put(newname, "");
            ++i;
        }
        return result;
    }
}

