/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.rcp.speech.gtalk;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import jp.sourceforge.akjrcp.commons.util.FileNameUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jpn.xucker.commons.audio.JavaSoundAudioPlayer;
import org.jpn.xucker.rcp.speech.gtalk.GtalkListener;

public class Gtalk {
    public static Log log = LogFactory.getLog(Gtalk.class.getClass());
    public static final String MALE1 = "male01";
    public static final String MALE2 = "male02";
    public static final String FEMALE1 = "female01";
    private String speaker = "male01";
    private GtalkListener listener;
    private boolean playing;
    public static String last_log = null;
    public static final String BUSY = "busy_process";
    public static final String DEFAULT_SETTING_NAME = "ssm.conf";
    private String gtalkBaseDir;
    private String gtalkSettringPath;
    private Process process;
    private JavaSoundAudioPlayer player;

    public String getGtalkBaseDir() {
        return this.gtalkBaseDir;
    }

    public void setGtalkBaseDir(String gtalkBaseDir) {
        this.gtalkBaseDir = gtalkBaseDir;
    }

    public String getGtalkSettringPath() {
        return this.gtalkSettringPath;
    }

    public void setGtalkSettringPath(String gtalkSettringPath) {
        this.gtalkSettringPath = gtalkSettringPath;
    }

    public GtalkListener getListener() {
        return this.listener;
    }

    public void setListener(GtalkListener listener) {
        this.listener = listener;
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public void setPlaying(boolean playing) {
        this.playing = playing;
    }

    public Process getProcess() {
        return this.process;
    }

    public void setProcess(Process process) {
        this.process = process;
    }

    public String getSpeaker() {
        return this.speaker;
    }

    public void setSpeaker(String speaker) {
        this.speaker = speaker;
    }

    public void play(String text) throws IOException {
        this.play(new String[]{text});
    }

    public void playVista(String[] texts) {
        block7: {
            try {
                try {
                    File tmp = File.createTempFile("speak", ".wav");
                    tmp.deleteOnExit();
                    this.writeWav(texts, tmp);
                    if (this.player == null) {
                        this.player = new JavaSoundAudioPlayer();
                    }
                    if (tmp.length() > 0L) {
                        this.player.play(tmp);
                        tmp.delete();
                        break block7;
                    }
                    log.warn((Object)"file-size is 0");
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.playing = false;
                }
            }
            finally {
                this.playing = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play(String[] texts) throws IOException {
        if (this.playing) {
            log.debug((Object)"now playing");
            return;
        }
        if (FileNameUtils.isVista()) {
            this.playVista(texts);
            return;
        }
        this.playing = true;
        int i = 0;
        while (i < texts.length) {
            if (this.gtalkBaseDir == null) {
                log.warn((Object)"gtalkBaseDir not found");
                throw new IOException("gtalkBaseDir not found");
            }
            if (this.gtalkSettringPath == null) {
                log.warn((Object)"gtalkSettringPath not found");
                throw new IOException("gtalkSettringPath not found");
            }
            if (this.listener != null) {
                this.listener.playStart();
            } else {
                log.trace((Object)"listener is null");
            }
            Runtime runtime = Runtime.getRuntime();
            log.info((Object)("text='" + texts[i] + "',length=" + texts[i].length()));
            String values = "";
            values = String.valueOf(values) + "set Speaker=" + this.speaker + "\r\n";
            values = String.valueOf(values) + "set Text=" + texts[i] + "\r\n";
            values = String.valueOf(values) + "set Speak=NOW\r\n";
            try {
                Gtalk gtalk;
                String[] command = new String[]{new File(this.gtalkBaseDir, "gtalk.exe").getAbsolutePath(), "-C", this.gtalkSettringPath};
                log.info((Object)ArrayUtils.toString((Object)command));
                log.info((Object)("gtalk base=" + this.gtalkBaseDir));
                this.process = runtime.exec(new String[]{new File(this.gtalkBaseDir, "gtalk.exe").getAbsolutePath(), "-C", this.gtalkSettringPath}, new String[0], new File(this.gtalkBaseDir));
                String line = null;
                BufferedReader reader = null;
                if (this.process != null) {
                    Gtalk gtalk2 = this;
                    synchronized (gtalk2) {
                        if (this.process != null) {
                            reader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
                            line = reader.readLine();
                        }
                    }
                }
                PrintWriter writer = null;
                if (this.process != null) {
                    gtalk = this;
                    synchronized (gtalk) {
                        if (this.process != null) {
                            writer = new PrintWriter(this.process.getOutputStream());
                            writer.write(values);
                            writer.close();
                        }
                    }
                }
                if (reader != null) {
                    while ((line = reader.readLine()) != null && this.process != null) {
                        log.info((Object)("line:" + line));
                        if (line.equals("rep Speak.stat = SPEAKING")) {
                            reader.close();
                            try {
                                Thread.sleep(300L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            break;
                        }
                        if (!line.equals("rep Speak.stat = IDLE")) continue;
                        if (this.process != null) {
                            gtalk = this;
                            synchronized (gtalk) {
                                if (this.process != null) {
                                    this.process.destroy();
                                    last_log = null;
                                }
                            }
                        }
                        this.process = null;
                        break;
                    }
                }
                if (this.process != null && (reader = new BufferedReader(new InputStreamReader(this.process.getErrorStream()))) != null) {
                    while ((line = reader.readLine()) != null && this.process != null) {
                        log.warn((Object)line);
                        if (!line.equals("..\\unidic-sjis-1.1.0\\chadic.da: No error")) continue;
                        last_log = BUSY;
                    }
                }
                log.info((Object)"close");
                if (this.process != null) {
                    this.process.destroy();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                this.playing = false;
                return;
            }
            ++i;
        }
        this.playing = false;
        if (this.listener != null) {
            this.listener.playEnd();
        } else {
            log.trace((Object)"listener is null");
        }
    }

    public void writeRaw(String text, File file) throws IOException {
        this.writeRaw(new String[]{text}, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeRaw(String[] texts, File file) throws IOException {
        if (this.playing) {
            log.debug((Object)"now playing");
            return;
        }
        this.playing = true;
        ArrayList<File> tmpFileList = new ArrayList<File>();
        int i = 0;
        while (i < texts.length) {
            block26: {
                File tmpFile = File.createTempFile("tmp", "raw");
                tmpFileList.add(tmpFile);
                if (this.listener != null) {
                    this.listener.writeStart(file);
                } else {
                    log.trace((Object)"listener is null");
                }
                Runtime runtime = Runtime.getRuntime();
                String values = "";
                values = String.valueOf(values) + "set Speaker=" + this.speaker + "\r\n";
                values = String.valueOf(values) + "set Text=" + texts[i] + "\r\n";
                values = String.valueOf(values) + "set Save=" + tmpFile.getAbsolutePath() + "\r\n";
                String other = MALE1;
                if (this.speaker.equals(MALE1)) {
                    other = MALE2;
                }
                values = String.valueOf(values) + "set Speaker=" + other + "\r\n";
                String match = "rep Speaker = " + other;
                try {
                    Gtalk gtalk;
                    this.process = runtime.exec(new String[]{new File(this.gtalkBaseDir, "gtalk.exe").getAbsolutePath(), "-C", this.gtalkSettringPath}, new String[0], new File(this.gtalkBaseDir));
                    BufferedReader reader = null;
                    if (this.process != null) {
                        gtalk = this;
                        synchronized (gtalk) {
                            if (this.process != null) {
                                reader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
                                String string = reader.readLine();
                            }
                        }
                    }
                    if (this.process != null) {
                        gtalk = this;
                        synchronized (gtalk) {
                            if (this.process != null) {
                                PrintWriter writer = new PrintWriter(this.process.getOutputStream());
                                log.info((Object)values);
                                writer.write(values);
                                writer.close();
                            }
                        }
                    }
                    if (reader != null) {
                        String line;
                        while ((line = reader.readLine()) != null) {
                            log.info((Object)line);
                            if (line.equals(match)) break;
                        }
                    }
                    if (this.process == null) break block26;
                    gtalk = this;
                    synchronized (gtalk) {
                        if (this.process != null) {
                            this.process.destroy();
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.playing = false;
                    return;
                }
            }
            ++i;
        }
        File[] tmpFiles = tmpFileList.toArray(new File[tmpFileList.size()]);
        this.mixFile(tmpFiles, file);
        int i2 = 0;
        while (i2 < tmpFiles.length) {
            tmpFiles[i2].delete();
            ++i2;
        }
        this.playing = false;
        if (this.listener != null) {
            this.listener.writeEnd(file);
        } else {
            log.trace((Object)"listener is null");
        }
    }

    public void mixFile(File[] files, File output) {
        try {
            byte[] bytes = new byte[10240];
            BufferedOutputStream writer = new BufferedOutputStream(new FileOutputStream(output));
            int i = 0;
            while (i < files.length) {
                int readed;
                BufferedInputStream reader = new BufferedInputStream(new FileInputStream(files[i]));
                log.trace((Object)("mixfile-read:" + files[i].getAbsolutePath()));
                while ((readed = reader.read(bytes)) >= 0) {
                    writer.write(bytes, 0, readed);
                }
                reader.close();
                ++i;
            }
            log.trace((Object)("mixfile-write:" + output.getAbsolutePath()));
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeWav(String text, File wavFile) throws IOException {
        this.writeWav(new String[]{text}, wavFile);
    }

    public void writeWav(String[] texts, File wavFile) throws IOException {
        File tmpOut = File.createTempFile("gtalk", ".raw");
        this.writeRaw(texts, tmpOut);
        AudioFormat format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 16000.0f, 16, 1, 2, 16000.0f, false);
        log.trace((Object)("file-length:" + tmpOut.length()));
        AudioInputStream inputStream = new AudioInputStream(new FileInputStream(tmpOut), format, tmpOut.length() / 2L);
        FileOutputStream output = new FileOutputStream(wavFile);
        long writtenBytes = AudioSystem.write(inputStream, AudioFileFormat.Type.WAVE, output);
        log.trace((Object)("writebyte:" + writtenBytes));
        inputStream.close();
        output.flush();
        output.close();
        boolean result = tmpOut.delete();
        log.trace((Object)("tmp delete:" + result));
        this.playing = false;
    }

    public void cancel() {
        if (this.process != null) {
            OutputStream output = this.process.getOutputStream();
            if (output != null) {
                PrintWriter writer = new PrintWriter(output);
                writer.write("set Speak = STOP\r\n");
                writer.close();
            } else {
                log.info((Object)"output is null");
            }
        } else {
            log.info((Object)"process is null");
        }
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (this.process != null) {
            this.process.destroy();
            this.process = null;
        } else {
            log.trace((Object)"process is null");
        }
        if (this.listener != null) {
            this.listener.canceled();
        } else {
            log.trace((Object)"listener is null");
        }
        last_log = null;
    }

    public void dispose() {
        if (this.process != null) {
            this.process.destroy();
        }
    }

    public class Reader
    extends Thread {
        InputStream input;

        public Reader(InputStream input) {
            this.input = input;
        }

        @Override
        public void run() {
            System.out.println("started:");
            try {
                int b;
                while ((b = this.input.read()) != -1) {
                    System.out.print((char)b);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

