/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.rcp.speech;

import java.io.File;
import jp.sourceforge.akjrcp.commons.util.FileNameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.jpn.xucker.rcp.speech.PostWindowOpen;
import org.jpn.xucker.rcp.speech.actions.LanguageAction;
import org.jpn.xucker.rcp.speech.views.PlayTextView;
import org.jpn.xucker.rcp.speech.views.VoiceSettingView;
import org.jpn.xucker.speech.multi.MultiTypeTextPlayer;
import org.jpn.xucker.speech.multi.MultiTypeTextSpeech;
import org.jpn.xucker.speech.multi.USJPSplitter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class SpeechPlugin
extends AbstractUIPlugin {
    private static SpeechPlugin plugin;
    public static String PLUGIN_ID;
    public static Log log;
    private MultiTypeTextSpeech speech;
    private MultiTypeTextPlayer usPlayer;
    private MultiTypeTextPlayer jpPlayer;
    public static final int US_JP = 0;
    public static final int US = 1;
    public static final int JP = 2;
    private int languageMode = 0;

    static {
        PLUGIN_ID = "org.jpn.xucker.rcp.speech";
        log = LogFactory.getLog(SpeechPlugin.class);
    }

    public MultiTypeTextPlayer getJpPlayer() {
        return this.jpPlayer;
    }

    public void setJpPlayer(MultiTypeTextPlayer jpPlayer) {
        this.jpPlayer = jpPlayer;
    }

    public MultiTypeTextPlayer getUsPlayer() {
        return this.usPlayer;
    }

    public void setUsPlayer(MultiTypeTextPlayer usPlayer) {
        this.usPlayer = usPlayer;
    }

    public int getLanguageMode() {
        return this.languageMode;
    }

    public void setLanguageMode(int languageMode) {
        this.languageMode = languageMode;
    }

    public SpeechPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.getPreferenceStore().setDefault("export.type", "wave");
        Bundle bundle = Platform.getBundle((String)"jp.sourceforge.akjrcp.lib.FreeTTS");
        log.info((Object)bundle.getLocation());
        File defaultDir = new File(System.getProperty("user.home"));
        defaultDir = new File(FileNameUtils.getMyMusicPath());
        System.out.println(defaultDir);
        if (defaultDir.exists()) {
            this.getPreferenceStore().setDefault("export.directory", defaultDir.getAbsolutePath());
        }
        this.getPreferenceStore().setDefault("export.wave.samplebit", 16);
        this.getPreferenceStore().setDefault("export.wave.samplerate", 11025);
        this.getPreferenceStore().setDefault("export.wave.channel", 1);
        this.getPreferenceStore().setDefault("export.ogg.quality", 50);
        this.getPreferenceStore().setDefault("export.ogg.samplerate", 44100);
        this.getPreferenceStore().setDefault("export.ogg.channel", 2);
        this.getPreferenceStore().setDefault("male01.pitch", 1.0);
        this.getPreferenceStore().setDefault("male02.pitch", 1.0);
        this.getPreferenceStore().setDefault("female01.pitch", 1.0);
        this.getPreferenceStore().setDefault("male01.pitch_range", 1.0);
        this.getPreferenceStore().setDefault("male02.pitch_range", 1.0);
        this.getPreferenceStore().setDefault("female01.pitch_range", 1.0);
        this.getPreferenceStore().setDefault("male01.duration", 1.0);
        this.getPreferenceStore().setDefault("male02.duration", 1.0);
        this.getPreferenceStore().setDefault("female01.duration", 1.0);
    }

    public void stop(BundleContext context) throws Exception {
        SpeechPlugin.getDefault().getJpPlayer().dispose();
        super.stop(context);
    }

    public static SpeechPlugin getDefault() {
        return plugin;
    }

    public MultiTypeTextSpeech getSpeech() {
        if (this.speech == null) {
            log.info((Object)"post");
            log.trace((Object)"start postWindowOpen");
            PlayTextView playTextView = (PlayTextView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(PlayTextView.VIEW_ID);
            log.trace((Object)("playTextView:" + (Object)((Object)playTextView)));
            playTextView.setActionEnabled(false, "org.jpn.xucker.rcp.speech.actions.PlayerAction.stop");
            playTextView.setSelection(LanguageAction.ID_JP_US);
            log.trace((Object)"call MultiTypeTextSpeech");
            MultiTypeTextSpeech tmpSpeech = new MultiTypeTextSpeech();
            tmpSpeech.addMultiTypeSpeechListener(playTextView.getSpeechListener());
            log.trace((Object)"call voiceSettingView");
            try {
                VoiceSettingView voiceSettingView = (VoiceSettingView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(VoiceSettingView.VIEW_ID);
                if (voiceSettingView != null) {
                    tmpSpeech.addPlayer(voiceSettingView.getUsPlayer());
                    SpeechPlugin.getDefault().setUsPlayer(voiceSettingView.getUsPlayer());
                }
            }
            catch (Error e) {
                e.printStackTrace();
            }
            tmpSpeech.setSpliter(new USJPSplitter());
            SpeechPlugin.getDefault().setSpeech(tmpSpeech);
            try {
                log.trace((Object)"call postWindowOpen");
                PostWindowOpen.postWindow();
            }
            catch (Error e) {
                e.printStackTrace();
            }
        }
        log.info((Object)this.speech);
        return this.speech;
    }

    public void setSpeech(MultiTypeTextSpeech speech) {
        this.speech = speech;
    }
}

