/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.rcp.speech;

import java.util.ArrayList;
import org.jpn.xucker.rcp.audio.FileDialogLabelBuilder;
import org.jpn.xucker.rcp.audio.format.AudioTypeFormat;
import org.jpn.xucker.rcp.audio.format.OggAudioTypeFormat;
import org.jpn.xucker.rcp.audio.format.WavAudioTypeFormat;
import org.jpn.xucker.rcp.speech.SpeechPlugin;

public class AudioFileUtils {
    public static String[] createFileDialogExtension() {
        AudioTypeFormat[] formats = AudioFileUtils.getAudioTypeFormats();
        String[] labels = FileDialogLabelBuilder.createFilterExtensions((AudioTypeFormat[])formats, (boolean)true, (boolean)true);
        return labels;
    }

    public static AudioTypeFormat[] getAudioTypeFormats() {
        AudioTypeFormat[] formats = new AudioTypeFormat[]{new WavAudioTypeFormat(), new OggAudioTypeFormat()};
        String defaultType = SpeechPlugin.getDefault().getPreferenceStore().getString("export.type");
        ArrayList<AudioTypeFormat> tmpList = new ArrayList<AudioTypeFormat>();
        int i = 0;
        while (i < formats.length) {
            if (formats[i].getName().equals(defaultType)) {
                tmpList.add(formats[i]);
                break;
            }
            ++i;
        }
        i = 0;
        while (i < formats.length) {
            if (!formats[i].getName().equals(defaultType)) {
                tmpList.add(formats[i]);
            }
            ++i;
        }
        return tmpList.toArray(new AudioTypeFormat[tmpList.size()]);
    }

    public static String[] createFileDialogName() {
        AudioTypeFormat[] formats = AudioFileUtils.getAudioTypeFormats();
        String[] labels = FileDialogLabelBuilder.createFilterNames((AudioTypeFormat[])formats, (boolean)true, (boolean)true);
        return labels;
    }

    public static String getExtensionByFileDialogName(String item) {
        AudioTypeFormat[] formats = AudioFileUtils.getAudioTypeFormats();
        int i = 0;
        while (i < formats.length) {
            if (formats[i].getFileDialogLabel().equals(item)) {
                String[] extension = formats[i].getExtension();
                if (extension == null || extension.length <= 0) break;
                return extension[0];
            }
            ++i;
        }
        return null;
    }
}

