/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.rcp.mediainfo.views;

import java.io.File;
import java.io.IOException;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.jpn.xucker.rcp.mediainfo.Info;
import org.jpn.xucker.rcp.mediainfo.MediaInfoParser;
import org.jpn.xucker.rcp.mediainfo.MediaInfoRcpPlugin;

public class MediaInfoView
extends ViewPart {
    public static final String ID_VIEW;
    private Label pathLabel;
    private Tree tree;
    private Label infoLabel;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jpn.xucker.rcp.mediainfo.views.MediaInfoView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ID_VIEW = clazz.getName();
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        this.pathLabel = new Label(parent, 0);
        this.pathLabel.setLayoutData((Object)new GridData(768));
        Button browse = new Button(parent, 0);
        browse.addSelectionListener((SelectionListener)new FileChoice());
        browse.setText("browse");
        this.tree = new Tree(parent, 0);
        GridData data = new GridData(1808);
        this.tree.setLayoutData((Object)data);
        this.infoLabel = new Label(parent, 0);
        this.infoLabel.setLayoutData((Object)new GridData(768));
    }

    private void setTree() {
        MediaInfoParser parser = new MediaInfoParser(MediaInfoRcpPlugin.getDefault().getPluginPreferences().getString("mediainfo_path"));
        try {
            this.tree.removeAll();
            Info[] infos = parser.parse(new File(this.pathLabel.getText()));
            this.infoLabel.setText(parser.getMediaInfoInfomation());
            int i = 0;
            while (i < infos.length) {
                TreeItem item = new TreeItem(this.tree, 0);
                item.setText(infos[i].getName());
                String[] keys = infos[i].getKeys();
                int j = 0;
                while (j < keys.length) {
                    TreeItem keyvalue = new TreeItem(item, 0);
                    keyvalue.setText(keys[j]);
                    String[] values = infos[i].getValues(keys[j]);
                    int k = 0;
                    while (k < values.length) {
                        TreeItem valueItem = new TreeItem(keyvalue, 0);
                        valueItem.setText(values[k]);
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setFocus() {
    }

    public class FileChoice
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            String mediaInfoPath = MediaInfoRcpPlugin.getDefault().getPluginPreferences().getString("mediainfo_path");
            if (mediaInfoPath.length() == 0 || !new File(mediaInfoPath).exists()) {
                MessageBox box = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                box.setText("mediainfo path is wrong");
                box.setMessage("set media info path at preferences.\nor mediainfo.exe not found");
                box.open();
                return;
            }
            FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            String filePath = dialog.open();
            if (filePath != null) {
                MediaInfoView.this.pathLabel.setText(filePath);
                MediaInfoView.this.setTree();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

