/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.contexts;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.ui.internal.contexts.AbstractContextRegistry;
import org.eclipse.ui.internal.contexts.ContextDefinition;
import org.eclipse.ui.internal.contexts.Persistence;
import org.eclipse.ui.internal.util.ConfigurationElementMemento;

final class ExtensionContextRegistry
extends AbstractContextRegistry {
    private List contextContextBindingDefinitions;
    private List contextDefinitions;
    private IExtensionRegistry extensionRegistry;

    ExtensionContextRegistry(IExtensionRegistry extensionRegistry) {
        if (extensionRegistry == null) {
            throw new NullPointerException();
        }
        this.extensionRegistry = extensionRegistry;
        this.extensionRegistry.addRegistryChangeListener(new IRegistryChangeListener(){

            public void registryChanged(IRegistryChangeEvent registryChangeEvent) {
                IExtensionDelta[] extensionDeltas = registryChangeEvent.getExtensionDeltas("org.eclipse.ui", "contexts");
                if (extensionDeltas.length != 0) {
                    try {
                        ExtensionContextRegistry.this.load();
                    }
                    catch (IOException iOException) {}
                }
            }
        });
        try {
            this.load();
        }
        catch (IOException iOException) {}
    }

    private String getNamespace(IConfigurationElement configurationElement) {
        IExtension extension;
        String namespace = null;
        if (configurationElement != null && (extension = configurationElement.getDeclaringExtension()) != null) {
            namespace = extension.getNamespace();
        }
        return namespace;
    }

    private void load() throws IOException {
        String name;
        IConfigurationElement deprecatedConfigurationElement;
        if (this.contextContextBindingDefinitions == null) {
            this.contextContextBindingDefinitions = new ArrayList();
        } else {
            this.contextContextBindingDefinitions.clear();
        }
        if (this.contextDefinitions == null) {
            this.contextDefinitions = new ArrayList();
        } else {
            this.contextDefinitions.clear();
        }
        IConfigurationElement[] deprecatedConfigurationElements = this.extensionRegistry.getConfigurationElementsFor("org.eclipse.ui.acceleratorScopes");
        int i = 0;
        while (i < deprecatedConfigurationElements.length) {
            deprecatedConfigurationElement = deprecatedConfigurationElements[i];
            name = deprecatedConfigurationElement.getName();
            if ("acceleratorScope".equals(name)) {
                this.readContextDefinition(deprecatedConfigurationElement);
            }
            ++i;
        }
        deprecatedConfigurationElements = this.extensionRegistry.getConfigurationElementsFor("org.eclipse.ui.commands");
        i = 0;
        while (i < deprecatedConfigurationElements.length) {
            deprecatedConfigurationElement = deprecatedConfigurationElements[i];
            name = deprecatedConfigurationElement.getName();
            if ("scope".equals(name)) {
                this.readContextDefinition(deprecatedConfigurationElement);
            }
            ++i;
        }
        IConfigurationElement[] configurationElements = this.extensionRegistry.getConfigurationElementsFor("org.eclipse.ui.contexts");
        int i2 = 0;
        while (i2 < configurationElements.length) {
            IConfigurationElement configurationElement = configurationElements[i2];
            String name2 = configurationElement.getName();
            if ("context".equals(name2)) {
                this.readContextDefinition(configurationElement);
            }
            ++i2;
        }
        boolean contextRegistryChanged = false;
        if (!this.contextContextBindingDefinitions.equals(((AbstractContextRegistry)this).contextContextBindingDefinitions)) {
            ((AbstractContextRegistry)this).contextContextBindingDefinitions = Collections.unmodifiableList(this.contextContextBindingDefinitions);
            contextRegistryChanged = true;
        }
        if (!this.contextDefinitions.equals(((AbstractContextRegistry)this).contextDefinitions)) {
            ((AbstractContextRegistry)this).contextDefinitions = Collections.unmodifiableList(this.contextDefinitions);
            contextRegistryChanged = true;
        }
        if (contextRegistryChanged) {
            this.fireContextRegistryChanged();
        }
    }

    private void readContextDefinition(IConfigurationElement configurationElement) {
        ContextDefinition contextDefinition = Persistence.readContextDefinition(new ConfigurationElementMemento(configurationElement), this.getNamespace(configurationElement));
        if (contextDefinition != null) {
            this.contextDefinitions.add(contextDefinition);
        }
    }
}

