/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.ActionDescriptor;
import org.eclipse.ui.internal.ActionExpression;
import org.eclipse.ui.internal.PluginAction;
import org.eclipse.ui.internal.PluginActionBuilder;

public class ViewerActionBuilder
extends PluginActionBuilder {
    public static final String TAG_CONTRIBUTION_TYPE = "viewerContribution";
    private ISelectionProvider provider;
    private IWorkbenchPart part;

    protected ActionDescriptor createActionDescriptor(IConfigurationElement element) {
        ActionDescriptor desc = null;
        desc = this.part instanceof IViewPart ? new ActionDescriptor(element, 2, this.part) : new ActionDescriptor(element, 4, this.part);
        if (this.provider != null) {
            PluginAction action = desc.getAction();
            this.provider.addSelectionChangedListener((ISelectionChangedListener)action);
        }
        return desc;
    }

    protected PluginActionBuilder.BasicContribution createContribution() {
        return new ViewerContribution(this.provider);
    }

    public void dispose() {
        if (this.cache != null) {
            int i = 0;
            while (i < this.cache.size()) {
                ArrayList actions = ((PluginActionBuilder.BasicContribution)this.cache.get((int)i)).actions;
                if (actions != null) {
                    int j = 0;
                    while (j < actions.size()) {
                        PluginAction proxy = ((ActionDescriptor)actions.get(j)).getAction();
                        if (proxy.getDelegate() instanceof IActionDelegate2) {
                            ((IActionDelegate2)proxy.getDelegate()).dispose();
                        }
                        ++j;
                    }
                }
                ++i;
            }
            this.cache = null;
        }
    }

    protected boolean readElement(IConfigurationElement element) {
        String tag = element.getName();
        if (tag.equals("visibility")) {
            ((ViewerContribution)this.currentContribution).setVisibilityTest(element);
            return true;
        }
        return super.readElement(element);
    }

    public boolean readViewerContributions(String id, ISelectionProvider prov, IWorkbenchPart part) {
        this.provider = prov;
        this.part = part;
        this.readContributions(id, TAG_CONTRIBUTION_TYPE, "popupMenus");
        return this.cache != null;
    }

    private static class ViewerContribution
    extends PluginActionBuilder.BasicContribution {
        private ISelectionProvider selProvider;
        private ActionExpression visibilityTest;

        public ViewerContribution(ISelectionProvider selProvider) {
            this.selProvider = selProvider;
        }

        public void setVisibilityTest(IConfigurationElement element) {
            this.visibilityTest = new ActionExpression(element);
        }

        public void contribute(IMenuManager menu, boolean menuAppendIfMissing, IToolBarManager toolbar, boolean toolAppendIfMissing) {
            boolean visible = true;
            if (this.visibilityTest != null) {
                ISelection selection = this.selProvider.getSelection();
                visible = selection instanceof IStructuredSelection ? this.visibilityTest.isEnabledFor((IStructuredSelection)selection) : this.visibilityTest.isEnabledFor(selection);
            }
            if (visible) {
                super.contribute(menu, menuAppendIfMissing, toolbar, toolAppendIfMissing);
            }
        }
    }
}

