/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.rcp.audiotools.views;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.jpn.xucker.rcp.audiotools.AudioConverter;
import org.jpn.xucker.rcp.audiotools.AudioFormat;
import org.jpn.xucker.rcp.audiotools.AudioSetting;
import org.jpn.xucker.rcp.audiotools.AudioToolsPlugin;
import org.jpn.xucker.rcp.audiotools.Messages;
import org.jpn.xucker.rcp.audiotools.formats.DefaultFormat;
import org.jpn.xucker.rcp.audiotools.tools.ToolsUtil;
import org.jpn.xucker.rcp.mediainfo.AudioInfo;
import org.jpn.xucker.rcp.mediainfo.Info;
import org.jpn.xucker.rcp.mediainfo.MediaInfoParser;
import org.jpn.xucker.rcp.mediainfo.MediaInfoRcpPlugin;
import org.jpn.xucker.rcp.ui.FileDirChoicer;
import org.jpn.xucker.rcp.ui.FileOverwriteControler;
import org.jpn.xucker.rcp.ui.FileStatusChangeEvent;
import org.jpn.xucker.rcp.ui.FileStatusChangeListener;

public class SimpleConvertView
extends ViewPart {
    public static Log log;
    public static String ID_VIEW;
    private Button convertButton;
    private CCombo toolSelect;
    private FileDirChoicer input;
    private FileDirChoicer output;
    private CCombo sampleRateCombo;
    private CCombo bitRateCombo;
    private Label bitrateLabel;
    private Button sameInput;
    private AudioSetting inputSetting;
    private AudioFormat exportFormat = null;
    private boolean bitrateAvailable = true;
    private boolean samplebitAvailable = true;
    private boolean sampleRateAvailable = true;
    private boolean channelAvailable = true;
    private Composite channelRateComposite;
    private Composite sampleBitComposite;
    private Composite sampleRateComposite;
    private Composite bitrateComposite;
    private Label samplebitLabel;
    private CCombo sampleBitCombo;
    private Label sampleRateLabel;
    private Label channelLabel;
    private Button stereoButton;
    private Button monoButton;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jpn.xucker.rcp.audiotools.views.SimpleConvertView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.jpn.xucker.rcp.audiotools.views.SimpleConvertView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ID_VIEW = clazz2.getName();
    }

    public void createPartControl(Composite parent) {
        ListCheck listCheck = new ListCheck();
        parent.setLayout((Layout)new GridLayout());
        Composite topComposite = new Composite(parent, 0);
        topComposite.setLayoutData((Object)new GridData(768));
        topComposite.setLayout((Layout)new GridLayout(2, false));
        Composite buttonComposite = new Composite(topComposite, 0);
        buttonComposite.setLayout((Layout)new GridLayout(1, false));
        GridData bt = new GridData();
        bt.verticalSpan = 2;
        buttonComposite.setLayoutData((Object)bt);
        this.convertButton = new Button(buttonComposite, 0);
        this.convertButton.setText(Messages.getString("convert"));
        this.convertButton.setEnabled(false);
        this.convertButton.addSelectionListener((SelectionListener)new CheckConvert());
        GridData cb = new GridData(1040);
        cb.widthHint = 100;
        cb.heightHint = 100;
        this.convertButton.setLayoutData((Object)cb);
        buttonComposite.setToolTipText(Messages.getString("if_cant_convert"));
        this.toolSelect = new CCombo(buttonComposite, 8);
        this.toolSelect.setEnabled(false);
        GridData ts = new GridData(1040);
        ts.widthHint = 100;
        this.toolSelect.setLayoutData((Object)ts);
        Group g1 = new Group(topComposite, 0);
        g1.setLayoutData((Object)new GridData(768));
        g1.setText(Messages.getString("inputfile"));
        g1.setLayout((Layout)new GridLayout());
        this.input = new FileDirChoicer((Composite)g1, 0, 0, "");
        this.input.setLayoutData((Object)new GridData(768));
        this.input.addFileListChangeListener((FileStatusChangeListener)listCheck);
        this.input.setBrowseButtonText(Messages.getString("inputfile_browse"));
        this.input.pack();
        Group g2 = new Group(topComposite, 0);
        g2.setText(Messages.getString("outputfile"));
        g2.setLayout((Layout)new GridLayout());
        g2.setLayoutData((Object)new GridData(768));
        this.output = new FileDirChoicer((Composite)g2, 0, 2, null);
        this.output.addFileListChangeListener((FileStatusChangeListener)listCheck);
        this.output.setLayoutData((Object)new GridData(768));
        this.output.setBrowseButtonText(Messages.getString("outputfile_browse"));
        this.output.layout();
        this.sameInput = new Button(parent, 32);
        this.sameInput.setSelection(true);
        this.sameInput.setText(Messages.getString("use_input_setting"));
        this.sameInput.addSelectionListener((SelectionListener)new SettingCheck());
        this.sameInput.setEnabled(false);
        Composite setOutputComposite = new Composite(parent, 0);
        setOutputComposite.setLayout((Layout)new GridLayout(2, true));
        this.bitrateComposite = new Composite(setOutputComposite, 0);
        this.bitrateComposite.setLayout((Layout)new GridLayout(2, false));
        this.bitrateLabel = new Label(this.bitrateComposite, 0);
        this.bitrateLabel.setText(Messages.getString("bitrate"));
        this.bitRateCombo = new CCombo(this.bitrateComposite, 8);
        this.sampleRateComposite = new Composite(setOutputComposite, 0);
        this.sampleRateComposite.setLayout((Layout)new GridLayout(2, false));
        this.sampleRateLabel = new Label(this.sampleRateComposite, 0);
        this.sampleRateLabel.setText(Messages.getString("samplerate"));
        this.sampleRateCombo = new CCombo(this.sampleRateComposite, 8);
        this.sampleBitComposite = new Composite(setOutputComposite, 0);
        this.sampleBitComposite.setLayout((Layout)new GridLayout(2, false));
        this.samplebitLabel = new Label(this.sampleBitComposite, 0);
        this.samplebitLabel.setText(Messages.getString("samplebit"));
        this.sampleBitCombo = new CCombo(this.sampleBitComposite, 8);
        this.channelRateComposite = new Composite(setOutputComposite, 0);
        this.channelRateComposite.setLayout((Layout)new GridLayout(3, false));
        this.channelLabel = new Label(this.channelRateComposite, 0);
        this.channelLabel.setText(Messages.getString("channel"));
        this.stereoButton = new Button(this.channelRateComposite, 16);
        this.stereoButton.setText(Messages.getString("stereo"));
        this.monoButton = new Button(this.channelRateComposite, 16);
        this.monoButton.setText(Messages.getString("monoral"));
        this.setBitrateAvailable(false);
        this.setSamplebitAvailable(false);
        this.setSampleRateAvailable(false);
        this.setChannelAvailable(false);
        this.initSetting();
    }

    private void initSetting() {
        int i;
        if (this.exportFormat == null) {
            this.exportFormat = new DefaultFormat();
        }
        if (this.exportFormat.getAvailableBitrate() != null) {
            this.bitRateCombo.removeAll();
            i = 0;
            while (i < this.exportFormat.getAvailableBitrate().length) {
                this.bitRateCombo.add(this.toBitrateLabel(this.exportFormat.getAvailableBitrate()[i]));
                ++i;
            }
            this.bitrateAvailable = true;
            this.bitRateCombo.select(this.bitRateCombo.getItemCount() - 1);
        } else {
            this.bitrateAvailable = false;
        }
        if (this.exportFormat.getAvailableSamplebit() != null) {
            this.sampleBitCombo.removeAll();
            i = 0;
            while (i < this.exportFormat.getAvailableSamplebit().length) {
                this.sampleBitCombo.add(this.toSampleBitLabel(this.exportFormat.getAvailableSamplebit()[i]));
                ++i;
            }
            this.samplebitAvailable = true;
            this.sampleBitCombo.select(this.sampleBitCombo.getItemCount() - 1);
        } else {
            this.samplebitAvailable = false;
        }
        if (this.exportFormat.getAvailableSampleRate() != null) {
            this.sampleRateCombo.removeAll();
            i = 0;
            while (i < this.exportFormat.getAvailableSampleRate().length) {
                this.sampleRateCombo.add(this.toSampleRateLabel(this.exportFormat.getAvailableSampleRate()[i]));
                ++i;
            }
            this.sampleRateAvailable = true;
            this.sampleRateCombo.select(this.sampleRateCombo.getItemCount() - 1);
        } else {
            this.sampleRateAvailable = false;
        }
        this.channelAvailable = this.exportFormat.getAvailableChannels() != null;
    }

    private String toSampleBitLabel(int i) {
        String label = "" + i;
        if (label.length() < 2) {
            label = " " + label;
        }
        return String.valueOf(label) + " bit";
    }

    public void setBitrateAvailable(boolean bool) {
        this.bitrateLabel.setEnabled(bool);
        this.bitRateCombo.setEnabled(bool);
    }

    public void setSamplebitAvailable(boolean bool) {
        this.samplebitLabel.setEnabled(bool);
        this.sampleBitCombo.setEnabled(bool);
    }

    public void setSampleRateAvailable(boolean bool) {
        this.sampleRateLabel.setEnabled(bool);
        this.sampleRateCombo.setEnabled(bool);
    }

    public void setChannelAvailable(boolean bool) {
        this.channelLabel.setEnabled(bool);
        this.stereoButton.setEnabled(bool);
        this.monoButton.setEnabled(bool);
    }

    public void updateExportSetting() {
        if (this.sameInput.getSelection()) {
            this.setBitrateAvailable(false);
            this.setSamplebitAvailable(false);
            this.setSampleRateAvailable(false);
            this.setChannelAvailable(false);
        } else {
            this.setBitrateAvailable(this.bitrateAvailable);
            this.setSamplebitAvailable(this.samplebitAvailable);
            this.setSampleRateAvailable(this.sampleRateAvailable);
            this.setChannelAvailable(this.channelAvailable);
        }
    }

    private String toBitrateLabel(int value) {
        String label = "";
        label = "" + value;
        label = label.substring(0, label.length() - 3);
        while (label.length() < 4) {
            label = " " + label;
        }
        label = String.valueOf(label) + " kbps";
        return label;
    }

    private String toSampleRateLabel(int value) {
        String label = "";
        label = "" + value;
        if ((label = String.valueOf(label.substring(0, label.length() - 3)) + "." + label.substring(label.length() - 3)).length() < 6) {
            label = " " + label;
        }
        label = String.valueOf(label) + " khz";
        return label;
    }

    public int toSampleRate() {
        int result = 0;
        String value = this.sampleRateCombo.getItem(this.sampleRateCombo.getSelectionIndex());
        if (value.endsWith("khz")) {
            double dv = Double.parseDouble(this.removeWhiteSpace(value.substring(0, value.length() - 3)));
            result = (int)(dv * 1000.0);
        }
        return result;
    }

    public int toSampleBit() {
        int result = 0;
        String value = this.sampleBitCombo.getItem(this.sampleBitCombo.getSelectionIndex());
        if (value.endsWith("bit")) {
            result = Integer.parseInt(this.removeWhiteSpace(value.substring(0, value.length() - 3)));
        }
        return result;
    }

    public int toBitrate() {
        int result = 0;
        String value = this.bitRateCombo.getItem(this.bitRateCombo.getSelectionIndex());
        if (value.endsWith("kbps")) {
            result = Integer.parseInt(this.removeWhiteSpace(value.substring(0, value.length() - 4))) * 1000;
        }
        return result;
    }

    public int toChannel() {
        int result = 0;
        if (this.monoButton.getEnabled() && this.monoButton.getSelection()) {
            result = 1;
        } else if (this.stereoButton.getEnabled() && this.stereoButton.getSelection()) {
            result = 2;
        }
        return result;
    }

    public AudioSetting toSetting() {
        AudioSetting setting = null;
        if (!this.sameInput.getSelection()) {
            String value;
            setting = new AudioSetting();
            if (this.sampleRateCombo.getEnabled()) {
                setting.setSamplerate(this.toSampleRate());
            }
            if (this.sampleBitCombo.getEnabled()) {
                setting.setSamplebit(this.toSampleBit());
            }
            if (this.bitRateCombo.getEnabled() && (value = this.bitRateCombo.getItem(this.bitRateCombo.getSelectionIndex())).endsWith("kbps")) {
                setting.setBitrate(this.toBitrate());
            }
            setting.setChannel(this.toChannel());
        }
        return setting;
    }

    public String getInputType() {
        String result = null;
        return result;
    }

    public String removeWhiteSpace(String value) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < value.length()) {
            if (!Character.isWhitespace(value.charAt(i))) {
                result.append(value.charAt(i));
            }
            ++i;
        }
        return result.toString();
    }

    public void setFocus() {
    }

    public class SettingCheck
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            if (SimpleConvertView.this.sameInput.getSelection()) {
                SimpleConvertView.this.setBitrateAvailable(false);
                SimpleConvertView.this.setSamplebitAvailable(false);
                SimpleConvertView.this.setSampleRateAvailable(false);
                SimpleConvertView.this.setChannelAvailable(false);
            } else {
                SimpleConvertView.this.updateExportSetting();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    public class ListCheck
    implements FileStatusChangeListener {
        private String inputExtension;
        private String outputExtension;
        private String prevOutputPath = "";

        public void removeList(FileStatusChangeEvent arg0) {
        }

        public void addList(FileStatusChangeEvent arg0) {
            File file;
            if (arg0.item == SimpleConvertView.this.output) {
                file = new File(SimpleConvertView.this.output.getAbsoluteFilePath());
                if (file.exists()) {
                    FileOverwriteControler controler = new FileOverwriteControler(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 1);
                    boolean result = controler.canOverwrite(file);
                    System.out.println(result);
                    if (!result) {
                        SimpleConvertView.this.output.setFilePath(this.prevOutputPath);
                    }
                }
                this.prevOutputPath = SimpleConvertView.this.output.getAbsoluteFilePath();
            }
            SimpleConvertView.this.toolSelect.removeAll();
            this.inputExtension = ToolsUtil.getExtension(SimpleConvertView.this.input.getAbsoluteFilePath()).toLowerCase();
            this.outputExtension = ToolsUtil.getExtension(SimpleConvertView.this.output.getAbsoluteFilePath()).toLowerCase();
            if (this.outputExtension.length() > 0) {
                SimpleConvertView.this.sameInput.setEnabled(true);
                SimpleConvertView.this.exportFormat = this.findFormat(this.outputExtension);
                SimpleConvertView.this.initSetting();
                SimpleConvertView.this.updateExportSetting();
            } else {
                SimpleConvertView.this.sameInput.setEnabled(false);
            }
            if (this.inputExtension.length() > 0 && this.outputExtension.length() > 0) {
                AudioConverter[] converters = AudioToolsPlugin.getDefault().getAudioConverters();
                int i = 0;
                while (i < converters.length) {
                    if (converters[i].canConvert(this.inputExtension, this.outputExtension)) {
                        SimpleConvertView.this.toolSelect.add(converters[i].getName());
                    }
                    ++i;
                }
            }
            if (SimpleConvertView.this.toolSelect.getItemCount() > 0) {
                SimpleConvertView.this.toolSelect.select(0);
                SimpleConvertView.this.convertButton.setEnabled(true);
                SimpleConvertView.this.toolSelect.setEnabled(true);
            } else {
                SimpleConvertView.this.convertButton.setEnabled(false);
                SimpleConvertView.this.toolSelect.setEnabled(false);
            }
            if (arg0.item == SimpleConvertView.this.input && (file = new File(SimpleConvertView.this.input.getAbsoluteFilePath())).exists()) {
                this.setUpInputSetting(SimpleConvertView.this.input.getAbsoluteFilePath());
            }
            if (SimpleConvertView.this.inputSetting != null) {
                this.setSettingValue();
            }
        }

        private void setSettingValue() {
            log.trace((Object)SimpleConvertView.this.inputSetting);
            this.setSettingChannel(SimpleConvertView.this.inputSetting.getChannel());
            this.setSettingSampleRate(SimpleConvertView.this.inputSetting.getSamplerate());
            this.setSettingSampleBit(SimpleConvertView.this.inputSetting.getSamplebit());
            this.setSettingBitRate(SimpleConvertView.this.inputSetting.getBitrate());
            if (SimpleConvertView.this.toSampleRate() < 32000 && SimpleConvertView.this.toBitrate() > 160000) {
                this.setSettingBitRate(160000);
            }
        }

        private AudioFormat findFormat(String outputExtension2) {
            AudioFormat[] formats = AudioToolsPlugin.getDefault().getAudioFormats();
            int i = 0;
            while (i < formats.length) {
                String[] extensions = formats[i].getAvailableExtension();
                if (extensions != null) {
                    int j = 0;
                    while (j < extensions.length) {
                        if (extensions[j].equals(outputExtension2)) {
                            return formats[i];
                        }
                        ++j;
                    }
                }
                ++i;
            }
            return null;
        }

        private void setUpInputSetting(String absoluteFilePath) {
            MediaInfoParser parser = MediaInfoRcpPlugin.getDefault().getParser();
            try {
                log.trace((Object)absoluteFilePath);
                Info[] infos = parser.parse(new File(absoluteFilePath));
                int i = 0;
                while (i < infos.length) {
                    if (infos[i] instanceof AudioInfo) {
                        AudioInfo audioInfo = (AudioInfo)infos[i];
                        int bitrate = audioInfo.getBitrate();
                        int samplerate = audioInfo.getSamplingrate();
                        int samplebit = audioInfo.getSampleBit();
                        int channel = audioInfo.getChannels();
                        log.trace((Object)(String.valueOf(bitrate) + "," + samplerate + "," + samplebit + "," + channel));
                        SimpleConvertView.this.inputSetting = new AudioSetting();
                        SimpleConvertView.this.inputSetting.setChannel(channel);
                        SimpleConvertView.this.inputSetting.setBitrate(bitrate);
                        SimpleConvertView.this.inputSetting.setSamplebit(samplebit);
                        SimpleConvertView.this.inputSetting.setSamplerate(samplerate);
                        log.trace((Object)SimpleConvertView.this.inputSetting);
                        break;
                    }
                    ++i;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private void setSettingBitRate(int bitrate) {
            if (this.outputExtension.equals("wav")) {
                return;
            }
            int size = SimpleConvertView.this.bitRateCombo.getItemCount();
            String label = SimpleConvertView.this.toBitrateLabel(bitrate);
            int index = -1;
            int i = 0;
            while (i < size) {
                if (label.equals(SimpleConvertView.this.bitRateCombo.getItem(i))) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (index != -1) {
                SimpleConvertView.this.bitRateCombo.select(index);
            }
        }

        private void setSettingSampleBit(int samplebit) {
            String label = this.toSampleBitLabel(samplebit);
            int index = -1;
            int size = SimpleConvertView.this.sampleBitCombo.getItemCount();
            int i = 0;
            while (i < size) {
                if (label.equals(SimpleConvertView.this.sampleBitCombo.getItem(i))) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (index != -1) {
                SimpleConvertView.this.sampleBitCombo.select(index);
            }
        }

        private void setSettingChannel(int channel) {
            if (channel == 1) {
                SimpleConvertView.this.monoButton.setSelection(true);
                SimpleConvertView.this.stereoButton.setSelection(false);
            } else if (channel == 2) {
                SimpleConvertView.this.stereoButton.setSelection(true);
                SimpleConvertView.this.monoButton.setSelection(false);
            }
        }

        private String toSampleBitLabel(int bit) {
            String label = "bit";
            if (label.length() < 5) {
                label = " " + label;
            }
            return label;
        }

        private void setSettingSampleRate(int rate) {
            int size = SimpleConvertView.this.sampleRateCombo.getItemCount();
            String label = SimpleConvertView.this.toSampleRateLabel(rate);
            int index = -1;
            int i = 0;
            while (i < size) {
                if (label.equals(SimpleConvertView.this.sampleRateCombo.getItem(i))) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (index != -1) {
                SimpleConvertView.this.sampleRateCombo.select(index);
            }
        }
    }

    public class CheckConvert
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            AudioConverter convert = null;
            AudioConverter[] converters = AudioToolsPlugin.getDefault().getAudioConverters();
            int i = 0;
            while (i < converters.length) {
                if (converters[i].getName().equals(SimpleConvertView.this.toolSelect.getItem(SimpleConvertView.this.toolSelect.getSelectionIndex()))) {
                    convert = converters[i];
                    break;
                }
                ++i;
            }
            if (convert != null) {
                SimpleConvertView.this.input.setEnabled(false);
                SimpleConvertView.this.output.setEnabled(false);
                SimpleConvertView.this.convertButton.setEnabled(false);
                SimpleConvertView.this.toolSelect.setEnabled(false);
                ExecConvert t = new ExecConvert(convert, SimpleConvertView.this.input.getAbsoluteFilePath(), SimpleConvertView.this.output.getAbsoluteFilePath());
                t.start();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public class ExecConvert
        extends Thread {
            private String inputPath;
            private String outputPath;
            private AudioConverter converter;
            private AudioSetting setting;

            public ExecConvert(AudioConverter converter, String input, String output) {
                this.inputPath = input;
                this.outputPath = output;
                this.converter = converter;
                this.setting = SimpleConvertView.this.toSetting();
            }

            public void run() {
                try {
                    this.converter.convert(new File(this.inputPath), new File(this.outputPath), this.setting, SimpleConvertView.this.inputSetting);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                PlatformUI.getWorkbench().getDisplay().asyncExec((Runnable)new Enabled());
            }
        }

        public class Enabled
        extends Thread {
            public void run() {
                SimpleConvertView.this.input.setEnabled(true);
                SimpleConvertView.this.output.setEnabled(true);
                SimpleConvertView.this.convertButton.setEnabled(true);
                SimpleConvertView.this.toolSelect.setEnabled(true);
            }
        }
    }
}

