/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.standalone;

import java.net.MalformedURLException;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.internal.core.Policy;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.operations.DuplicateConflictsValidator;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.operations.IBatchOperation;
import org.eclipse.update.operations.IInstallFeatureOperation;
import org.eclipse.update.operations.OperationsManager;
import org.eclipse.update.search.IUpdateSearchResultCollector;
import org.eclipse.update.search.UpdateSearchRequest;
import org.eclipse.update.search.VersionedIdentifiersFilter;
import org.eclipse.update.standalone.ScriptedCommand;
import org.eclipse.update.standalone.StandaloneUpdateApplication;

public class UpdateCommand
extends ScriptedCommand {
    private IConfiguredSite targetSite;
    private UpdateSearchRequest searchRequest;
    private UpdateSearchResultCollector collector;
    private String featureId;
    private String version;
    private IFeature currentFeature;

    public UpdateCommand(String featureId, String verifyOnly) throws Exception {
        this(featureId, null, verifyOnly);
    }

    public UpdateCommand(String featureId, String version, String verifyOnly) throws Exception {
        super(verifyOnly);
        try {
            this.featureId = featureId;
            this.version = version;
            if (featureId != null) {
                this.targetSite = UpdateUtils.getSiteWithFeature(this.getConfiguration(), featureId);
                if (this.targetSite == null) {
                    throw new Exception(Policy.bind("Standalone.noConfigSiteForFeature", featureId));
                }
                IFeature[] currentFeatures = UpdateUtils.searchSite(featureId, this.targetSite, true);
                if (currentFeatures == null || currentFeatures.length == 0) {
                    throw new Exception(Policy.bind("Standalone.noFeatures3", featureId));
                }
                this.currentFeature = currentFeatures[0];
            } else {
                IConfiguredSite[] sites = this.getConfiguration().getConfiguredSites();
                int i = 0;
                while (i < sites.length) {
                    if (sites[i].isProductSite()) {
                        this.targetSite = sites[i];
                        break;
                    }
                    ++i;
                }
            }
            if (this.currentFeature == null) {
                this.searchRequest = UpdateUtils.createNewUpdatesRequest(null);
            } else {
                this.searchRequest = UpdateUtils.createNewUpdatesRequest(new IFeature[]{this.currentFeature});
                if (version != null) {
                    this.searchRequest.addFilter(new VersionedIdentifiersFilter(new VersionedIdentifier[]{new VersionedIdentifier(featureId, version)}));
                }
            }
            this.collector = new UpdateSearchResultCollector();
        }
        catch (MalformedURLException e) {
            StandaloneUpdateApplication.exceptionLogged();
            UpdateCore.log(e);
        }
        catch (CoreException e) {
            StandaloneUpdateApplication.exceptionLogged();
            UpdateCore.log(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean run(IProgressMonitor monitor) {
        block16: {
            block15: {
                block14: {
                    block13: {
                        IStatus status = OperationsManager.getValidator().validatePlatformConfigValid();
                        if (status != null) {
                            UpdateCore.log(status);
                            return false;
                        }
                        try {
                            try {
                                monitor.beginTask(Policy.bind("Standalone.updating"), 4);
                                this.searchRequest.performSearch(this.collector, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                IInstallFeatureOperation[] operations = this.collector.getOperations();
                                if (operations == null || operations.length == 0) {
                                    StandaloneUpdateApplication.exceptionLogged();
                                    UpdateCore.log(Utilities.newCoreException(Policy.bind("Standalone.noUpdate", this.featureId), null));
                                    Object var7_5 = null;
                                    break block13;
                                }
                                ArrayList conflicts = DuplicateConflictsValidator.computeDuplicateConflicts(operations, this.getConfiguration());
                                if (conflicts != null) {
                                    StandaloneUpdateApplication.exceptionLogged();
                                    UpdateCore.log(Utilities.newCoreException(Policy.bind("Standalone.duplicate"), null));
                                    break block14;
                                }
                                if (this.isVerifyOnly()) {
                                    status = OperationsManager.getValidator().validatePendingChanges(operations);
                                    if (status != null && status.getCode() == 4) {
                                        throw new CoreException(status);
                                    }
                                    break block15;
                                }
                                IBatchOperation installOperation = OperationsManager.getOperationFactory().createBatchInstallOperation(operations);
                                try {
                                    installOperation.execute((IProgressMonitor)new SubProgressMonitor(monitor, 3), this);
                                    System.out.println(String.valueOf(Policy.bind("Standalone.feature")) + this.featureId + " " + Policy.bind("Standalone.updated"));
                                    break block16;
                                }
                                catch (Exception e) {
                                    StandaloneUpdateApplication.exceptionLogged();
                                    UpdateCore.log(Utilities.newCoreException(Policy.bind("Standalone.noUpdate", this.featureId), e));
                                    Object var7_9 = null;
                                    monitor.done();
                                    return false;
                                }
                            }
                            catch (CoreException ce) {
                                status = ce.getStatus();
                                if (status != null && status.getCode() == 42) {
                                    System.out.println(Policy.bind("Standalone.connection"));
                                } else {
                                    StandaloneUpdateApplication.exceptionLogged();
                                    UpdateCore.log(ce);
                                }
                                Object var7_10 = null;
                                monitor.done();
                                return false;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var7_11 = null;
                            monitor.done();
                            throw throwable;
                        }
                    }
                    monitor.done();
                    return false;
                }
                Object var7_6 = null;
                monitor.done();
                return false;
            }
            Object var7_7 = null;
            monitor.done();
            return true;
        }
        Object var7_8 = null;
        monitor.done();
        return true;
    }

    class UpdateSearchResultCollector
    implements IUpdateSearchResultCollector {
        private ArrayList operations = new ArrayList();

        UpdateSearchResultCollector() {
        }

        public void accept(IFeature feature) {
            IInstallFeatureOperation op = OperationsManager.getOperationFactory().createInstallOperation(null, feature, null, null, null);
            IConfiguredSite site = UpdateUtils.getDefaultTargetSite(UpdateCommand.this.getConfiguration(), op);
            if (site == null) {
                site = UpdateUtils.getAffinitySite(UpdateCommand.this.getConfiguration(), feature);
            }
            if (site == null) {
                site = UpdateCommand.this.targetSite;
            }
            op.setTargetSite(site);
            this.operations.add(op);
        }

        public IInstallFeatureOperation[] getOperations() {
            IInstallFeatureOperation[] opsArray = new IInstallFeatureOperation[this.operations.size()];
            this.operations.toArray(opsArray);
            return opsArray;
        }
    }
}

