/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.core;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureContentProvider;
import org.eclipse.update.core.INonPluginEntry;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.InstallMonitor;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.model.InstallAbortedException;
import org.eclipse.update.core.model.NonPluginEntryModel;
import org.eclipse.update.core.model.PluginEntryModel;
import org.eclipse.update.internal.core.FeatureDownloadException;
import org.eclipse.update.internal.core.FileFragment;
import org.eclipse.update.internal.core.InternalSiteManager;
import org.eclipse.update.internal.core.Policy;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;

public abstract class FeatureContentProvider
implements IFeatureContentProvider {
    private static final boolean SWITCH_COPY_LOCAL = true;
    private URL base;
    private IFeature feature;
    private File tmpDir;
    public static final String JAR_EXTENSION = ".jar";
    private static final String DOT_PERMISSIONS = "permissions.properties";
    private static final String EXECUTABLES = "permissions.executable";
    private static final Object lock = new Object();
    private static Hashtable locks = new Hashtable();

    public FeatureContentProvider(URL base) {
        this.base = base;
        this.feature = null;
    }

    public URL getURL() {
        return this.base;
    }

    public IFeature getFeature() {
        return this.feature;
    }

    public void setFeature(IFeature feature) {
        this.feature = feature;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ContentReference asLocalReference(ContentReference ref, InstallMonitor monitor) throws IOException, CoreException {
        if (ref.isLocalReference()) {
            return ref;
        }
        String key = ref.toString();
        File localFile = null;
        FileFragment localFileFragment = null;
        Object keyLock = null;
        Object object = lock;
        synchronized (object) {
            if (locks.get(key) == null) {
                locks.put(key, key);
            }
            keyLock = locks.get(key);
        }
        object = keyLock;
        synchronized (object) {
            boolean success;
            long bytesCopied;
            OutputStream os;
            block46: {
                localFile = Utilities.lookupLocalFile(key);
                if (localFile != null && UpdateManagerUtils.isSameTimestamp(ref.asURL(), localFile.lastModified())) {
                    return ref.createContentReference(ref.getIdentifier(), localFile);
                }
                if (localFile == null) {
                    localFileFragment = UpdateManagerUtils.lookupLocalFileFragment(key);
                }
                InputStream is = null;
                os = null;
                bytesCopied = 0L;
                long inputLength = 0L;
                success = false;
                if (monitor != null) {
                    monitor.saveState();
                    monitor.setTaskName(Policy.bind("FeatureContentProvider.Downloading"));
                    monitor.subTask(String.valueOf(ref.getIdentifier()) + " ");
                    monitor.setTotalCount(ref.getInputSize());
                    monitor.showCopyDetails(true);
                }
                try {
                    try {
                        long offset;
                        if (localFileFragment != null && "http".equals(ref.asURL().getProtocol())) {
                            localFile = localFileFragment.getFile();
                            try {
                                is = ref.getPartialInputStream(localFileFragment.getSize());
                                inputLength = ref.getInputSize() - localFileFragment.getSize();
                                os = new BufferedOutputStream(new FileOutputStream(localFile, true));
                            }
                            catch (IOException iOException) {
                                try {
                                    if (is != null) {
                                        is.close();
                                    }
                                }
                                catch (IOException iOException2) {}
                                is = null;
                                os = null;
                                localFileFragment = null;
                            }
                        }
                        if (is == null) {
                            localFile = Utilities.createLocalFile(this.getWorkingDirectory(), null);
                            try {
                                is = ref.getInputStream();
                                inputLength = ref.getInputSize();
                            }
                            catch (IOException e) {
                                throw Utilities.newCoreException(Policy.bind("FeatureContentProvider.UnableToRetrieve", new Object[]{ref}), e);
                            }
                            try {
                                os = new BufferedOutputStream(new FileOutputStream(localFile));
                            }
                            catch (FileNotFoundException e) {
                                throw Utilities.newCoreException(Policy.bind("FeatureContentProvider.UnableToCreate", new Object[]{localFile}), e);
                            }
                        }
                        Date start = new Date();
                        if (localFileFragment != null) {
                            bytesCopied = localFileFragment.getSize();
                            if (monitor != null) {
                                monitor.incrementCount(bytesCopied);
                            }
                        }
                        if ((offset = UpdateManagerUtils.copy(is, os, monitor, inputLength)) != -1L) {
                            if ((bytesCopied += offset) > 0L) {
                                UpdateManagerUtils.mapLocalFileFragment(key, new FileFragment(localFile, bytesCopied));
                            }
                            if (!monitor.isCanceled()) throw new FeatureDownloadException(Policy.bind("FeatureContentProvider.ExceptionDownloading", new Object[]{this.getURL().toExternalForm()}), new IOException());
                            String msg = Policy.bind("Feature.InstallationCancelled");
                            throw new InstallAbortedException(msg, null);
                        }
                        UpdateManagerUtils.unMapLocalFileFragment(key);
                        Date stop = new Date();
                        long timeInseconds = (stop.getTime() - start.getTime()) / 1000L;
                        InternalSiteManager.downloaded(ref.getInputSize(), timeInseconds, ref.asURL());
                        success = true;
                        Utilities.mapLocalFile(key, localFile);
                    }
                    catch (ClassCastException e) {
                        throw Utilities.newCoreException(Policy.bind("FeatureContentProvider.UnableToCreate", new Object[]{localFile}), e);
                    }
                }
                catch (Throwable throwable) {
                    Object var21_22 = null;
                    if (success && is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (success || bytesCopied > 0L) {
                        localFile.setLastModified(ref.getLastModified());
                    }
                    if (monitor == null) throw throwable;
                    monitor.restoreState();
                    throw throwable;
                }
                {
                    Object var21_23 = null;
                    if (!success || is == null) break block46;
                }
                try {}
                catch (IOException iOException) {}
                is.close();
            }
            if (os != null) {
                try {}
                catch (IOException iOException) {}
                os.close();
            }
            if (success || bytesCopied > 0L) {
                localFile.setLastModified(ref.getLastModified());
            }
            if (monitor != null) {
                monitor.restoreState();
            }
            locks.remove(key);
            return ref.createContentReference(ref.getIdentifier(), localFile);
        }
    }

    public File asLocalFile(ContentReference ref, InstallMonitor monitor) throws IOException, CoreException {
        File file = ref.asFile();
        ContentReference localRef = this.asLocalReference(ref, monitor);
        file = localRef.asFile();
        return file;
    }

    protected File getWorkingDirectory() throws IOException {
        if (this.tmpDir == null) {
            this.tmpDir = Utilities.createWorkingDirectory();
        }
        return this.tmpDir;
    }

    public long getDownloadSizeFor(IPluginEntry[] pluginEntries, INonPluginEntry[] nonPluginEntries) {
        int i;
        long result = 0L;
        if (!(pluginEntries != null && pluginEntries.length != 0 || nonPluginEntries != null && nonPluginEntries.length != 0)) {
            return -1L;
        }
        long size = 0L;
        if (pluginEntries != null) {
            i = 0;
            while (i < pluginEntries.length) {
                size = ((PluginEntryModel)((Object)pluginEntries[i])).getDownloadSize();
                if (size == -1L) {
                    return -1L;
                }
                result += size;
                ++i;
            }
        }
        if (nonPluginEntries != null) {
            i = 0;
            while (i < nonPluginEntries.length) {
                size = ((NonPluginEntryModel)((Object)nonPluginEntries[i])).getDownloadSize();
                if (size == -1L) {
                    return -1L;
                }
                result += size;
                ++i;
            }
        }
        return result;
    }

    public long getInstallSizeFor(IPluginEntry[] pluginEntries, INonPluginEntry[] nonPluginEntries) {
        int i;
        long result = 0L;
        if (!(pluginEntries != null && pluginEntries.length != 0 || nonPluginEntries != null && nonPluginEntries.length != 0)) {
            return -1L;
        }
        long size = 0L;
        if (pluginEntries != null) {
            i = 0;
            while (i < pluginEntries.length) {
                size = ((PluginEntryModel)((Object)pluginEntries[i])).getInstallSize();
                if (size == -1L) {
                    return -1L;
                }
                result += size;
                ++i;
            }
        }
        if (nonPluginEntries != null) {
            i = 0;
            while (i < nonPluginEntries.length) {
                size = ((NonPluginEntryModel)((Object)nonPluginEntries[i])).getInstallSize();
                if (size == -1L) {
                    return -1L;
                }
                result += size;
                ++i;
            }
        }
        return result;
    }

    protected String getPathID(IPluginEntry entry) {
        return "plugins/" + entry.getVersionedIdentifier().toString() + JAR_EXTENSION;
    }

    protected String getPathID(INonPluginEntry entry) {
        String nonPluginBaseID = "features/" + this.feature.getVersionedIdentifier().toString() + "/";
        return String.valueOf(nonPluginBaseID) + entry.getIdentifier();
    }

    protected void validatePermissions(ContentReference[] references) {
        if (references == null || references.length == 0) {
            return;
        }
        Map permissions = this.getPermissions(references);
        if (permissions.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < references.length) {
            ContentReference contentReference = references[i];
            String id = contentReference.getIdentifier();
            Object value = null;
            value = this.matchesOneRule(id, permissions);
            if (value != null) {
                Integer permission = (Integer)value;
                contentReference.setPermission(permission);
            }
            ++i;
        }
    }

    private Object matchesOneRule(String id, Map permissions) {
        Set keySet = permissions.keySet();
        Iterator iter = keySet.iterator();
        while (iter.hasNext()) {
            FileFilter rule = (FileFilter)iter.next();
            if (!rule.accept(id)) continue;
            return permissions.get(rule);
        }
        return null;
    }

    private Map getPermissions(ContentReference[] references) {
        HashMap<FileFilter, Integer> result = new HashMap<FileFilter, Integer>();
        boolean notfound = true;
        ContentReference permissionReference = null;
        int i = 0;
        while (i < references.length && notfound) {
            ContentReference contentReference = references[i];
            if (DOT_PERMISSIONS.equals(contentReference.getIdentifier())) {
                notfound = false;
                permissionReference = contentReference;
            }
            ++i;
        }
        if (notfound) {
            return result;
        }
        Properties prop = new Properties();
        try {
            prop.load(permissionReference.getInputStream());
        }
        catch (IOException e) {
            UpdateCore.warn("", e);
        }
        String executables = prop.getProperty(EXECUTABLES);
        if (executables == null) {
            return result;
        }
        StringTokenizer tokenizer = new StringTokenizer(executables, ",");
        Integer defaultExecutablePermission = new Integer(-1);
        while (tokenizer.hasMoreTokens()) {
            FileFilter filter = new FileFilter(tokenizer.nextToken());
            result.put(filter, defaultExecutablePermission);
        }
        return result;
    }

    public class FileFilter {
        private IPath filterPath = null;

        public FileFilter(String filter) {
            this.filterPath = new Path(filter);
        }

        public boolean accept(String name) {
            IPath noExtension;
            String fileName;
            if (name == null) {
                return false;
            }
            Path namePath = new Path(name);
            if (this.filterPath.lastSegment().indexOf(42) == -1) {
                return this.filterPath.equals((Object)namePath);
            }
            String extension = this.filterPath.getFileExtension();
            if (!extension.equals("*") ? !extension.equalsIgnoreCase(namePath.getFileExtension()) : !(fileName = (noExtension = this.filterPath.removeFileExtension()).lastSegment()).equals("*") && !namePath.lastSegment().startsWith(fileName)) {
                return false;
            }
            IPath p1 = namePath.removeLastSegments(1);
            IPath p2 = this.filterPath.removeLastSegments(1);
            return p1.equals((Object)p2);
        }
    }
}

