/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.console;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleListener;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.internal.console.ConsoleMessages;

public class ConsoleManager
implements IConsoleManager {
    private ListenerList fListeners = null;
    private List fConsoles = new ArrayList(10);
    private static final int ADDED = 1;
    private static final int REMOVED = 2;

    public void addConsoleListener(IConsoleListener listener) {
        if (this.fListeners == null) {
            this.fListeners = new ListenerList(5);
        }
        this.fListeners.add((Object)listener);
    }

    public void removeConsoleListener(IConsoleListener listener) {
        if (this.fListeners != null) {
            this.fListeners.remove((Object)listener);
        }
    }

    public synchronized void addConsoles(IConsole[] consoles) {
        ArrayList<IConsole> added = new ArrayList<IConsole>(consoles.length);
        int i = 0;
        while (i < consoles.length) {
            IConsole console = consoles[i];
            if (!this.fConsoles.contains(console)) {
                this.fConsoles.add(console);
                added.add(console);
            }
            ++i;
        }
        if (!added.isEmpty()) {
            this.fireUpdate(added.toArray(new IConsole[added.size()]), 1);
        }
    }

    public synchronized void removeConsoles(IConsole[] consoles) {
        ArrayList<IConsole> removed = new ArrayList<IConsole>(consoles.length);
        int i = 0;
        while (i < consoles.length) {
            IConsole console = consoles[i];
            if (this.fConsoles.remove(console)) {
                removed.add(console);
            }
            ++i;
        }
        if (!removed.isEmpty()) {
            this.fireUpdate(removed.toArray(new IConsole[removed.size()]), 2);
        }
    }

    public synchronized IConsole[] getConsoles() {
        return this.fConsoles.toArray(new IConsole[this.fConsoles.size()]);
    }

    private void fireUpdate(IConsole[] consoles, int type) {
        new ConsoleNotifier().notify(consoles, type);
    }

    public void showConsoleView(final IConsole console) {
        ConsolePlugin.getStandardDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page;
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window != null && (page = window.getActivePage()) != null) {
                    IViewPart consoleView = page.findView("org.eclipse.ui.console.ConsoleView");
                    if (consoleView == null) {
                        try {
                            consoleView = page.showView("org.eclipse.ui.console.ConsoleView", null, 3);
                        }
                        catch (PartInitException pie) {
                            ConsolePlugin.log(pie);
                        }
                    } else {
                        boolean bringToTop = ConsoleManager.this.shouldBringToTop(console, consoleView);
                        if (bringToTop) {
                            page.bringToTop((IWorkbenchPart)consoleView);
                        }
                    }
                    if (consoleView instanceof IConsoleView) {
                        ((IConsoleView)consoleView).display(console);
                    }
                }
            }
        });
    }

    private boolean shouldBringToTop(IConsole console, IViewPart consoleView) {
        IConsoleView cView;
        boolean bringToTop = true;
        if (consoleView instanceof IConsoleView && (cView = (IConsoleView)consoleView).isPinned()) {
            IConsole pinnedConsole = cView.getConsole();
            bringToTop = console.equals(pinnedConsole);
        }
        return bringToTop;
    }

    public void warnOfContentChange(IConsole console) {
        IConsoleView consoleView;
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null && (consoleView = (IConsoleView)page.findView("org.eclipse.ui.console.ConsoleView")) != null) {
            consoleView.warnOfContentChange(console);
        }
    }

    class ConsoleNotifier
    implements ISafeRunnable {
        private IConsoleListener fListener;
        private int fType;
        private IConsole[] fChanged;

        ConsoleNotifier() {
        }

        public void handleException(Throwable exception) {
            Status status = new Status(4, ConsolePlugin.getUniqueIdentifier(), 120, ConsoleMessages.getString("ConsoleManager.0"), exception);
            ConsolePlugin.log((IStatus)status);
        }

        public void run() throws Exception {
            switch (this.fType) {
                case 1: {
                    this.fListener.consolesAdded(this.fChanged);
                    break;
                }
                case 2: {
                    this.fListener.consolesRemoved(this.fChanged);
                }
            }
        }

        public void notify(IConsole[] consoles, int update) {
            if (ConsoleManager.this.fListeners == null) {
                return;
            }
            this.fChanged = consoles;
            this.fType = update;
            Object[] copiedListeners = ConsoleManager.this.fListeners.getListeners();
            int i = 0;
            while (i < copiedListeners.length) {
                this.fListener = (IConsoleListener)copiedListeners[i];
                Platform.run((ISafeRunnable)this);
                ++i;
            }
            this.fChanged = null;
            this.fListener = null;
        }
    }
}

