/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.commons.audio.word;

import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jpn.xucker.commons.audio.InputStreamAudioPlayer;
import org.jpn.xucker.commons.audio.word.AbstractWordPlayer;

public class ZipFileWordPlayer
extends AbstractWordPlayer {
    private InputStreamAudioPlayer player;
    protected String path;
    public static final int BOTH = 0;
    public static final int ALPHABET = 1;
    public static final int PLAIN = 2;
    private int mode;

    public ZipFileWordPlayer(String path) {
        this.path = path;
    }

    public ZipFileWordPlayer(String path, InputStreamAudioPlayer player) {
        this.player = player;
        this.path = path;
    }

    public InputStreamAudioPlayer getPlayer() {
        return this.player;
    }

    public void setPlayer(InputStreamAudioPlayer player) {
        this.player = player;
    }

    public void play(String word) {
        try {
            ZipFile zipFile = new ZipFile(this.path);
            ZipEntry entry = this.getZipEntry(word);
            this.player.play(zipFile.getInputStream(entry));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setZipFilePath(String path) {
        this.path = path;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    protected ZipEntry getZipEntry(String word) {
        ZipEntry entry = null;
        try {
            ZipFile zipFile = new ZipFile(this.path);
            if (this.mode == 0 || this.mode == 1) {
                String sub = "" + word.charAt(0);
                entry = zipFile.getEntry(String.valueOf(sub.toLowerCase()) + "/" + word.toLowerCase() + ".wav");
            }
            if (entry == null && (this.mode == 0 || this.mode == 2)) {
                entry = zipFile.getEntry(String.valueOf(word.toLowerCase()) + ".wav");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return entry;
    }

    public boolean exist(String word) {
        return this.getZipEntry(word) != null;
    }
}

