/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source;

import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.source.AnnotationBarHoverManager;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

class OverviewRulerHoverManager
extends AnnotationBarHoverManager {
    public OverviewRulerHoverManager(IOverviewRuler ruler, ISourceViewer sourceViewer, IAnnotationHover annotationHover, IInformationControlCreator creator) {
        super(ruler, sourceViewer, annotationHover, creator);
        this.setAnchor(AbstractInformationControlManager.ANCHOR_LEFT);
    }

    protected void computeInformation() {
        Point location = this.getHoverEventLocation();
        int line = this.getVerticalRulerInfo().toDocumentLineNumber(location.y);
        this.setInformation(this.getAnnotationHover().getHoverInfo(this.getSourceViewer(), line), this.computeArea(location.y));
    }

    private Rectangle computeArea(int y) {
        IOverviewRuler overviewRuler = (IOverviewRuler)this.getVerticalRulerInfo();
        int hover_height = overviewRuler.getAnnotationHeight();
        int hover_width = this.getVerticalRulerInfo().getControl().getSize().x;
        int hover_y = y;
        boolean hasAnnotation = true;
        while (hasAnnotation && hover_y > y - hover_height) {
            hasAnnotation = overviewRuler.hasAnnotation(--hover_y);
        }
        return new Rectangle(0, ++hover_y, hover_width, hover_height);
    }
}

