/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.contentassist;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.contentassist.IContentAssistSubjectControl;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IEventConsumer;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractControlContentAssistSubjectAdapter
implements IContentAssistSubjectControl {
    protected static final boolean DEBUG = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.jface.text/debug/ContentAssistSubjectAdapters"));
    private List fVerifyKeyListeners = new ArrayList(1);
    private Set fKeyListeners = new HashSet(1);
    private Listener fControlListener;

    public abstract Control getControl();

    public void addKeyListener(KeyListener keyListener) {
        this.fKeyListeners.add(keyListener);
        if (DEBUG) {
            System.out.println("AbstractControlContentAssistSubjectAdapter#addKeyListener()");
        }
        this.installControlListener();
    }

    public void removeKeyListener(KeyListener keyListener) {
        boolean deleted = this.fKeyListeners.remove(keyListener);
        if (DEBUG) {
            if (!deleted) {
                System.out.println("removeKeyListener -> wasn't here");
            }
            System.out.println("AbstractControlContentAssistSubjectAdapter#removeKeyListener() -> " + this.fKeyListeners.size());
        }
        this.uninstallControlListener();
    }

    public boolean supportsVerifyKeyListener() {
        return true;
    }

    public boolean appendVerifyKeyListener(VerifyKeyListener verifyKeyListener) {
        this.fVerifyKeyListeners.add(verifyKeyListener);
        if (DEBUG) {
            System.out.println("AbstractControlContentAssistSubjectAdapter#appendVerifyKeyListener() -> " + this.fVerifyKeyListeners.size());
        }
        this.installControlListener();
        return true;
    }

    public boolean prependVerifyKeyListener(VerifyKeyListener verifyKeyListener) {
        this.fVerifyKeyListeners.add(0, verifyKeyListener);
        if (DEBUG) {
            System.out.println("AbstractControlContentAssistSubjectAdapter#prependVerifyKeyListener() -> " + this.fVerifyKeyListeners.size());
        }
        this.installControlListener();
        return true;
    }

    public void removeVerifyKeyListener(VerifyKeyListener verifyKeyListener) {
        this.fVerifyKeyListeners.remove(verifyKeyListener);
        if (DEBUG) {
            System.out.println("AbstractControlContentAssistSubjectAdapter#removeVerifyKeyListener() -> " + this.fVerifyKeyListeners.size());
        }
        this.uninstallControlListener();
    }

    public void setEventConsumer(IEventConsumer eventConsumer) {
        if (DEBUG) {
            System.out.println("AbstractControlContentAssistSubjectAdapter#setEventConsumer()");
        }
    }

    public String getLineDelimiter() {
        return System.getProperty("line.separator");
    }

    private void installControlListener() {
        if (DEBUG) {
            System.out.println("AbstractControlContentAssistSubjectAdapter#installControlListener() -> k: " + this.fKeyListeners.size() + ", v: " + this.fVerifyKeyListeners.size());
        }
        if (this.fControlListener != null) {
            return;
        }
        this.fControlListener = new Listener(){

            public void handleEvent(Event e) {
                if (!AbstractControlContentAssistSubjectAdapter.this.getControl().isFocusControl()) {
                    return;
                }
                VerifyEvent verifyEvent = new VerifyEvent(e);
                KeyEvent keyEvent = new KeyEvent(e);
                switch (e.type) {
                    case 31: {
                        if (DEBUG) {
                            this.dump("before traverse", e, verifyEvent);
                        }
                        verifyEvent.doit = true;
                        Iterator iter = AbstractControlContentAssistSubjectAdapter.this.fVerifyKeyListeners.iterator();
                        while (iter.hasNext()) {
                            ((VerifyKeyListener)iter.next()).verifyKey(verifyEvent);
                            if (!verifyEvent.doit) {
                                e.detail = 0;
                                e.doit = true;
                                if (DEBUG) {
                                    this.dump("traverse eaten by verify", e, verifyEvent);
                                }
                                return;
                            }
                            if (!DEBUG) continue;
                            this.dump("traverse OK", e, verifyEvent);
                        }
                        break;
                    }
                    case 1: {
                        Iterator iter = AbstractControlContentAssistSubjectAdapter.this.fVerifyKeyListeners.iterator();
                        while (iter.hasNext()) {
                            ((VerifyKeyListener)iter.next()).verifyKey(verifyEvent);
                            if (verifyEvent.doit) continue;
                            e.doit = verifyEvent.doit;
                            if (DEBUG) {
                                this.dump("keyDown eaten by verify", e, verifyEvent);
                            }
                            return;
                        }
                        if (DEBUG) {
                            this.dump("keyDown OK", e, verifyEvent);
                        }
                        iter = AbstractControlContentAssistSubjectAdapter.this.fKeyListeners.iterator();
                        while (iter.hasNext()) {
                            ((KeyListener)iter.next()).keyPressed(keyEvent);
                        }
                        break;
                    }
                    default: {
                        Assert.isTrue((boolean)false);
                    }
                }
            }

            private void dump(String who, Event e, VerifyEvent ve) {
                StringBuffer sb = new StringBuffer("--- [AbstractControlContentAssistSubjectAdapter]\n");
                sb.append(who);
                sb.append(" - e: keyCode=" + e.keyCode + this.hex(e.keyCode));
                sb.append("; character=" + e.character + this.hex(e.character));
                sb.append("; stateMask=" + e.stateMask + this.hex(e.stateMask));
                sb.append("; doit=" + e.doit);
                sb.append("; detail=" + e.detail + this.hex(e.detail));
                sb.append("; widget=" + e.widget);
                sb.append("\n");
                sb.append("  verifyEvent keyCode=" + e.keyCode + this.hex(e.keyCode));
                sb.append("; character=" + e.character + this.hex(e.character));
                sb.append("; stateMask=" + e.stateMask + this.hex(e.stateMask));
                sb.append("; doit=" + ve.doit);
                sb.append("; widget=" + e.widget);
                System.out.println(sb);
            }

            private String hex(int i) {
                return "[0x" + Integer.toHexString(i) + ']';
            }
        };
        this.getControl().addListener(31, this.fControlListener);
        this.getControl().addListener(1, this.fControlListener);
        if (DEBUG) {
            System.out.println("AbstractControlContentAssistSubjectAdapter#installControlListener() - installed");
        }
    }

    private void uninstallControlListener() {
        if (this.fControlListener == null || this.fKeyListeners.size() + this.fVerifyKeyListeners.size() != 0) {
            if (DEBUG) {
                System.out.println("AbstractControlContentAssistSubjectAdapter#uninstallControlListener() -> k: " + this.fKeyListeners.size() + ", v: " + this.fVerifyKeyListeners.size());
            }
            return;
        }
        this.getControl().removeListener(31, this.fControlListener);
        this.getControl().removeListener(1, this.fControlListener);
        this.fControlListener = null;
        if (DEBUG) {
            System.out.println("AbstractControlContentAssistSubjectAdapter#uninstallControlListener() - done");
        }
    }

    public void setContentAssistCueProvider(ILabelProvider labelProvider) {
        SmartFieldController.setSmartCue(this.getControl(), labelProvider);
    }

    private static class SmartFieldController {
        private static final String SMART_FIELD_CONTROLLER = "org.eclipse.SmartFieldController";
        private static final String SMART_FOCUS_LISTENER = "org.eclipse.SmartFieldController.smartFocusListener";
        private static final String ANNOTATION_HANDLER = "org.eclipse.SmartFieldController.annotationHandler";
        private static String fgPlatform = SWT.getPlatform();
        private static boolean fgCarbon = "carbon".equals(fgPlatform);
        private static boolean fgWin32 = "win32".equals(fgPlatform);
        private Shell fShell;
        private ILabelProvider fLabelProvider;
        private Image fCueImage;
        private Hover fHover;
        private Control fHoverControl;
        static /* synthetic */ Class class$0;

        public static void setSmartCue(Control control, ILabelProvider labelProvider) {
            SmartFieldController.getSmartFieldController(control).internalSetSmartCue(control, labelProvider);
        }

        SmartFieldController(Shell shell) {
            this.fShell = shell;
            this.fShell.setData(SMART_FIELD_CONTROLLER, (Object)this);
            Listener l = new Listener(this){
                final /* synthetic */ SmartFieldController this$1;
                {
                    this.this$1 = smartFieldController;
                }

                public void handleEvent(Event event) {
                    switch (event.type) {
                        case 10: 
                        case 11: {
                            if (SmartFieldController.access$6(this.this$1) == null) break;
                            SmartFieldController.access$6(this.this$1).setLocation(SmartFieldController.access$7(this.this$1));
                            break;
                        }
                        case 12: {
                            Object data = SmartFieldController.access$8(this.this$1).getData("org.eclipse.SmartFieldController");
                            if (data != this.this$1) break;
                            SmartFieldController.access$8(this.this$1).setData("org.eclipse.SmartFieldController", null);
                            SmartFieldController.access$9(this.this$1);
                            break;
                        }
                        case 19: 
                        case 21: 
                        case 27: {
                            SmartFieldController.access$1(this.this$1, null, null);
                        }
                    }
                }
            };
            shell.addListener(12, l);
            shell.addListener(11, l);
            shell.addListener(10, l);
            shell.addListener(21, l);
            shell.addListener(27, l);
            shell.addListener(19, l);
        }

        private void handleDispose() {
            this.fShell = null;
            this.fHoverControl = null;
            if (this.fHover != null) {
                this.fHover.dispose();
                this.fHover = null;
            }
            if (this.fCueImage != null) {
                this.fCueImage.dispose();
                this.fCueImage = null;
            }
            if (this.fLabelProvider != null) {
                this.fLabelProvider.dispose();
                this.fLabelProvider = null;
            }
        }

        private static SmartFieldController getSmartFieldController(Control control) {
            Shell shell = control.getShell();
            Object data = shell.getData(SMART_FIELD_CONTROLLER);
            if (!(data instanceof SmartFieldController)) {
                data = new SmartFieldController(shell);
            }
            return (SmartFieldController)data;
        }

        private void internalSetSmartCue(Control control, ILabelProvider labelProvider) {
            if (this.fLabelProvider != null) {
                this.fLabelProvider.dispose();
            }
            this.fLabelProvider = labelProvider;
            FieldFocusListener focuslistener = (FieldFocusListener)control.getData(SMART_FOCUS_LISTENER);
            if (labelProvider != null) {
                if (focuslistener == null) {
                    focuslistener = new FieldFocusListener(control);
                    control.setData(SMART_FOCUS_LISTENER, (Object)focuslistener);
                    control.addFocusListener((FocusListener)focuslistener);
                }
            } else {
                if (focuslistener != null) {
                    control.removeFocusListener((FocusListener)focuslistener);
                    control.setData(SMART_FOCUS_LISTENER, null);
                }
                if (this.fCueImage != null) {
                    this.fCueImage.dispose();
                    this.fCueImage = null;
                }
            }
        }

        private void showHover(Control control, String text) {
            if (text != null) {
                this.fHoverControl = control;
                if (this.fHover == null) {
                    this.fHover = new Hover(this.fShell);
                }
                this.fHover.setText(text);
                this.fHover.setLocation(this.fHoverControl);
                this.fHover.setVisible(true);
            } else {
                this.fHoverControl = null;
                if (this.fHover != null) {
                    this.fHover.setVisible(false);
                }
            }
        }

        private boolean isHoverVisible() {
            return this.fHover != null && this.fHover.isVisible();
        }

        private Image getCueImage(Control control) {
            Image image = null;
            if (this.fLabelProvider != null) {
                image = this.fLabelProvider.getImage((Object)control);
            }
            return image != null ? image : this.getCueImage();
        }

        private Image getCueImage() {
            if (this.fCueImage == null) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.jface.contentassist.AbstractControlContentAssistSubjectAdapter$SmartFieldController");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                ImageDescriptor cueID = ImageDescriptor.createFromFile((Class)clazz, (String)"images/content_assist_cue.gif");
                this.fCueImage = cueID.createImage((Device)this.fShell.getDisplay());
            }
            return this.fCueImage;
        }

        static /* synthetic */ Hover access$6(SmartFieldController smartFieldController) {
            return smartFieldController.fHover;
        }

        static /* synthetic */ Control access$7(SmartFieldController smartFieldController) {
            return smartFieldController.fHoverControl;
        }

        static /* synthetic */ Shell access$8(SmartFieldController smartFieldController) {
            return smartFieldController.fShell;
        }

        static /* synthetic */ void access$9(SmartFieldController smartFieldController) {
            smartFieldController.handleDispose();
        }

        class Hover {
            private int HD = 10;
            private int HW = 8;
            private int HH = 10;
            private int LABEL_MARGIN = 2;
            Shell fHoverShell;
            String fText = "";

            Hover(Shell parent) {
                Display display = parent.getDisplay();
                this.fHoverShell = new Shell(parent, 540680);
                this.fHoverShell.setBackground(display.getSystemColor(29));
                this.fHoverShell.setForeground(display.getSystemColor(28));
                this.fHoverShell.addPaintListener(new PaintListener(this){
                    final /* synthetic */ Hover this$2;
                    {
                        this.this$2 = hover;
                    }

                    public void paintControl(PaintEvent pe) {
                        pe.gc.drawString(this.this$2.fText, Hover.access$0(this.this$2), Hover.access$0(this.this$2));
                        if (!SmartFieldController.access$0()) {
                            pe.gc.drawPolygon(this.this$2.getPolygon(true));
                        }
                    }
                });
                this.fHoverShell.addMouseListener((MouseListener)new MouseAdapter(this){
                    final /* synthetic */ Hover this$2;
                    {
                        this.this$2 = hover;
                    }

                    public void mouseDown(MouseEvent e) {
                        SmartFieldController.access$1(Hover.access$1(this.this$2), null, null);
                    }
                });
            }

            int[] getPolygon(boolean border) {
                Point e = this.getExtent();
                if (border) {
                    int[] nArray = new int[16];
                    nArray[2] = e.x - 1;
                    nArray[4] = e.x - 1;
                    nArray[5] = e.y - 1;
                    nArray[6] = this.HD + this.HW;
                    nArray[7] = e.y - 1;
                    nArray[8] = this.HD + this.HW / 2;
                    nArray[9] = e.y + this.HH - 1;
                    nArray[10] = this.HD;
                    nArray[11] = e.y - 1;
                    nArray[13] = e.y - 1;
                    return nArray;
                }
                int[] nArray = new int[16];
                nArray[2] = e.x;
                nArray[4] = e.x;
                nArray[5] = e.y;
                nArray[6] = this.HD + this.HW;
                nArray[7] = e.y;
                nArray[8] = this.HD + this.HW / 2;
                nArray[9] = e.y + this.HH;
                nArray[10] = this.HD;
                nArray[11] = e.y;
                nArray[13] = e.y;
                return nArray;
            }

            void dispose() {
                if (!this.fHoverShell.isDisposed()) {
                    this.fHoverShell.dispose();
                }
            }

            void setVisible(boolean visible) {
                if (visible) {
                    if (!this.fHoverShell.isVisible()) {
                        this.fHoverShell.setVisible(true);
                    }
                } else if (this.fHoverShell.isVisible()) {
                    this.fHoverShell.setVisible(false);
                }
            }

            void setText(String t) {
                if (t == null) {
                    t = "";
                }
                if (!t.equals(this.fText)) {
                    Point oldSize = this.getExtent();
                    this.fText = t;
                    this.fHoverShell.redraw();
                    Point newSize = this.getExtent();
                    if (!oldSize.equals((Object)newSize)) {
                        Region region = new Region();
                        region.add(this.getPolygon(false));
                        this.fHoverShell.setRegion(region);
                    }
                }
            }

            boolean isVisible() {
                return this.fHoverShell.isVisible();
            }

            void setLocation(Control control) {
                if (control != null) {
                    int h = this.getExtent().y;
                    this.fHoverShell.setLocation(control.toDisplay(-this.HD + this.HW / 2, -h - this.HH + 1));
                }
            }

            Point getExtent() {
                GC gc = new GC((Drawable)this.fHoverShell);
                Point e = gc.textExtent(this.fText);
                gc.dispose();
                e.x += this.LABEL_MARGIN * 2;
                e.y += this.LABEL_MARGIN * 2;
                return e;
            }

            static /* synthetic */ int access$0(Hover hover) {
                return hover.LABEL_MARGIN;
            }

            static /* synthetic */ SmartFieldController access$1(Hover hover) {
                return hover.SmartFieldController.this;
            }
        }

        class HoverHandler
        extends MouseTrackAdapter {
            FieldFocusListener fFieldFocusListener;

            HoverHandler(FieldFocusListener fieldFocusListener) {
                this.fFieldFocusListener = fieldFocusListener;
            }

            public void mouseHover(MouseEvent e) {
                this.handleMouseEvent(e);
            }

            public void mouseExit(MouseEvent e) {
                if (SmartFieldController.this.isHoverVisible()) {
                    this.fFieldFocusListener.doHideHover();
                }
            }

            void handleMouseEvent(MouseEvent e) {
                this.fFieldFocusListener.doShowHover();
            }
        }

        class CueHandler
        extends HoverHandler
        implements PaintListener {
            CueHandler(FieldFocusListener fieldFocusListener) {
                super(fieldFocusListener);
            }

            public void paintControl(PaintEvent e) {
                this.fFieldFocusListener.paintControl(e);
            }

            void handleMouseEvent(MouseEvent event) {
                this.fFieldFocusListener.updateHoverOnCue(event);
            }
        }

        class FieldFocusListener
        implements FocusListener {
            private Control fControl;
            private int fDx;
            private int fDy;
            private HoverHandler fHoverHandler;

            FieldFocusListener(Control control) {
                this.fControl = control;
                this.fDx = -5;
                this.fDy = 1;
                if (fgCarbon) {
                    if (control instanceof Text) {
                        this.fDy += 3;
                    } else if (control instanceof Combo) {
                        this.fDx -= 4;
                    }
                } else if (fgWin32 && control instanceof Text) {
                    this.fDx -= 2;
                    this.fDy -= 2;
                }
            }

            void paintControl(PaintEvent e) {
                if (this.fControl.isDisposed()) {
                    return;
                }
                Image image = SmartFieldController.this.getCueImage(this.fControl);
                Point global = this.fControl.toDisplay(this.fDx, this.fDy);
                Point local = ((Control)e.widget).toControl(global);
                e.gc.drawImage(image, local.x, local.y);
            }

            void updateHoverOnCue(MouseEvent e) {
                Image image = SmartFieldController.this.getCueImage(this.fControl);
                Rectangle r = image.getBounds();
                Point global = this.fControl.toDisplay(this.fDx, this.fDy);
                Point local = ((Control)e.widget).toControl(global);
                r.x = local.x;
                r.y = local.y;
                if (r.contains(e.x, e.y)) {
                    this.doShowHover();
                } else {
                    this.doHideHover();
                }
            }

            private void doHideHover() {
                SmartFieldController.this.showHover(this.fControl, null);
            }

            public void doShowHover() {
                SmartFieldController.this.showHover(this.fControl, SmartFieldController.this.fLabelProvider.getText((Object)this.fControl));
            }

            public void focusGained(FocusEvent e) {
                if (DEBUG) {
                    System.out.println("Focus Gained: " + e.widget);
                }
                if (this.fHoverHandler == null) {
                    this.fHoverHandler = new HoverHandler(this);
                    this.fControl.addMouseTrackListener((MouseTrackListener)this.fHoverHandler);
                }
                Composite c = this.fControl.getParent();
                while (c != null) {
                    if (DEBUG) {
                        System.out.println("install CueHandler: " + c.toString());
                    }
                    CueHandler cueHandler = new CueHandler(this);
                    Assert.isTrue((c.getData(SmartFieldController.ANNOTATION_HANDLER) == null ? 1 : 0) != 0, (String)("parent control has CueHandler: " + c.toString()));
                    c.setData(SmartFieldController.ANNOTATION_HANDLER, (Object)cueHandler);
                    c.addPaintListener((PaintListener)cueHandler);
                    c.addMouseTrackListener((MouseTrackListener)cueHandler);
                    c.redraw();
                    if (c instanceof Shell) break;
                    c = c.getParent();
                }
            }

            public void focusLost(FocusEvent e) {
                if (DEBUG) {
                    System.out.println("Focus Lost: " + e.widget + ", at:");
                    Thread.dumpStack();
                }
                if (this.fHoverHandler != null) {
                    this.fControl.removeMouseTrackListener((MouseTrackListener)this.fHoverHandler);
                }
                Composite c = this.fControl.getParent();
                while (c != null) {
                    CueHandler cueHandler;
                    if (DEBUG) {
                        System.out.println("uninstall CueHandler: " + c.toString());
                    }
                    if ((cueHandler = (CueHandler)((Object)c.getData(SmartFieldController.ANNOTATION_HANDLER))) != null) {
                        c.setData(SmartFieldController.ANNOTATION_HANDLER, null);
                        c.removePaintListener((PaintListener)cueHandler);
                        c.removeMouseTrackListener((MouseTrackListener)cueHandler);
                        c.redraw();
                    }
                    if (c instanceof Shell) break;
                    c = c.getParent();
                }
            }
        }
    }
}

