/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.rcp.optipngwrapper.views;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.part.ViewPart;
import org.jpn.xucker.commons.swt.ui.FileStatusChangeEvent;
import org.jpn.xucker.commons.swt.ui.FileStatusChangeListener;
import org.jpn.xucker.optipngwrapper.OptiPNGExecuter;
import org.jpn.xucker.optipngwrapper.ResultData;
import org.jpn.xucker.rcp.optipngwrapper.Messages;
import org.jpn.xucker.rcp.optipngwrapper.OptimizeListener;
import org.jpn.xucker.rcp.optipngwrapper.OptipngWrapperPlugin;
import org.jpn.xucker.rcp.optipngwrapper.views.FileListImageView;
import org.jpn.xucker.rcp.optipngwrapper.views.ResultView;

public class OptipngWrapperView
extends ViewPart
implements SelectionListener,
FileStatusChangeListener,
Runnable,
OptimizeListener {
    public static final String ID_VIEW;
    private Action action1;
    private Action action2;
    private Group group1;
    private Button sameoutput;
    private Text outputLabel;
    private Button outputButton;
    private Group group2;
    private Button dobackup;
    private Button optimizeButton;
    private Group group3;
    private Table table1;
    private Group group4;
    private CCombo level;
    private Text optiPngLabel;
    private Button optiPngButton;
    private Shell shell;
    private Image logoImage;
    OptiPNGExecuter executer = null;
    Thread thread = null;
    private Button keepmodified;
    int maxprogress;
    int currentprogress;
    private boolean executing = false;
    private IProgressMonitor monitor;
    private IPreferenceStore preference;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jpn.xucker.rcp.optipngwrapper.views.OptipngWrapperView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ID_VIEW = clazz.getName();
    }

    public void createPartControl(Composite parent) {
        this.shell = parent.getShell();
        parent.setLayout((Layout)new GridLayout(1, false));
        this.optimizeButton = new Button(parent, 0);
        this.optimizeButton.setText(Messages.getString("optimize"));
        this.optimizeButton.setEnabled(false);
        this.optimizeButton.addSelectionListener((SelectionListener)this);
        parent.setBackground(new Color((Device)Display.getCurrent(), 255, 255, 255));
        GridData optimizeButton_data = new GridData(1808);
        optimizeButton_data.heightHint = 32;
        this.optimizeButton.setLayoutData((Object)optimizeButton_data);
        this.group1 = new Group(parent, 0);
        this.group1.setText(Messages.getString("export"));
        this.group1.setLayout((Layout)new FillLayout(512));
        GridData group1_data = new GridData(768);
        this.group1.setLayoutData((Object)group1_data);
        this.sameoutput = new Button((Composite)this.group1, 32);
        this.sameoutput.setText(Messages.getString("overwrite_input"));
        this.sameoutput.addSelectionListener((SelectionListener)this);
        this.outputLabel = new Text((Composite)this.group1, 8);
        this.outputLabel.setText("");
        this.outputLabel.setBackground(new Color((Device)Display.getCurrent(), 255, 255, 255));
        GridData outputLabel_data = new GridData(768);
        this.outputLabel.setLayoutData((Object)outputLabel_data);
        Transfer[] types = new Transfer[]{FileTransfer.getInstance()};
        int operations = 3;
        DropTarget target2 = new DropTarget((Control)this.outputLabel, operations);
        target2.setTransfer(types);
        target2.addDropListener((DropTargetListener)new DropMonitor());
        this.outputButton = new Button((Composite)this.group1, 0);
        this.outputButton.setText(Messages.getString("output_dir"));
        this.outputButton.addSelectionListener((SelectionListener)this);
        new GridData();
        this.group2 = new Group(parent, 0);
        this.group2.setText(Messages.getString("option"));
        GridData group2_data = new GridData(768);
        this.group2.setLayoutData((Object)group2_data);
        this.group2.setLayout((Layout)new FillLayout(512));
        this.dobackup = new Button((Composite)this.group2, 32);
        this.dobackup.setText(Messages.getString("backup_before_optimize"));
        this.dobackup.setSelection(true);
        this.dobackup.addSelectionListener((SelectionListener)this);
        this.keepmodified = new Button((Composite)this.group2, 32);
        this.keepmodified.setText(Messages.getString("keep_last_modified"));
        this.keepmodified.setSelection(true);
        this.keepmodified.addSelectionListener((SelectionListener)this);
        this.group4 = new Group(parent, 0);
        this.group4.setText(Messages.getString("setting"));
        this.group4.setBackground(new Color((Device)Display.getCurrent(), 60, 180, 255));
        GridData group4_data = new GridData(768);
        this.group4.setLayoutData((Object)group4_data);
        GridLayout group4_layout = new GridLayout();
        this.group4.setLayout((Layout)group4_layout);
        Label label = new Label((Composite)this.group4, 0);
        label.setText(Messages.getString("level"));
        this.level = new CCombo((Composite)this.group4, 8);
        int i = 0;
        while (i <= 7) {
            this.level.add("" + i);
            ++i;
        }
        this.level.select(5);
        this.level.addSelectionListener((SelectionListener)this);
        GridData level_data = new GridData();
        this.level.setLayoutData((Object)level_data);
        this.optiPngLabel = new Text((Composite)this.group4, 8);
        this.optiPngLabel.setText("");
        GridData optiPngLabel_data = new GridData(768);
        this.optiPngLabel.setLayoutData((Object)optiPngLabel_data);
        this.optiPngButton = new Button((Composite)this.group4, 0);
        this.optiPngButton.setText(Messages.getString("optipng_path"));
        this.optiPngButton.addSelectionListener((SelectionListener)this);
        new GridData();
        this.logoImage = ImageDescriptor.createFromURL((URL)OptipngWrapperPlugin.getDefault().find((IPath)new Path("icons/optipngwrapper_logo.png"))).createImage();
        Label canvas = new Label(parent, 0);
        canvas.setImage(this.logoImage);
        GridData canvas_data = new GridData(832);
        canvas.setLayoutData((Object)canvas_data);
        this.preference = OptipngWrapperPlugin.getDefault().getPreferenceStore();
        String path = this.preference.getString("optipng_path");
        if (path.length() > 0) {
            this.optiPngLabel.setText(path);
        }
        String levelString = this.preference.getString("level");
        int index = 5;
        if (levelString.length() > 0) {
            index = Integer.parseInt(levelString);
            this.level.select(index);
        }
        this.keepmodified.setSelection(this.preference.getBoolean("keepmodified"));
        this.dobackup.setSelection(this.preference.getBoolean("dobackup"));
        this.sameoutput.setSelection(this.preference.getBoolean("sameoutput"));
        this.outputLabel.setText(this.preference.getString("output"));
        this.do_sameoutput();
    }

    public void setFocus() {
        this.level.setFocus();
    }

    public void widgetSelected(SelectionEvent event) {
        Object target = event.getSource();
        if (target == this.sameoutput) {
            this.do_sameoutput();
        } else if (target == this.outputButton) {
            this.do_outputButton();
        } else if (target == this.dobackup) {
            this.do_dobackup();
        } else if (target == this.optimizeButton) {
            this.do_optimizeButton();
        } else if (target == this.table1) {
            this.do_table1();
        } else if (target == this.level) {
            System.out.println(this.level.getSelectionIndex());
            this.do_level();
        } else if (target == this.optiPngButton) {
            this.do_optiPngButton();
        } else if (target == this.keepmodified) {
            this.do_keepmodifiedButton();
        }
    }

    private void do_keepmodifiedButton() {
        this.preference.setValue("keepmodified", this.keepmodified.getSelection());
    }

    public void run() {
        if (this.executer != null) {
            try {
                this.executer.execute();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.shell.getDisplay().asyncExec((Runnable)new CreateResultDialog(this.executer.getResultData()));
            this.executing = false;
        } else {
            System.out.println("executer null");
        }
        this.thread = null;
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    private void do_sameoutput() {
        this.preference.setValue("sameoutput", this.sameoutput.getSelection());
        if (this.sameoutput.getSelection()) {
            this.outputButton.setEnabled(false);
            this.outputLabel.setEnabled(false);
        } else {
            this.outputButton.setEnabled(true);
            this.outputLabel.setEnabled(true);
        }
    }

    public void do_outputButton() {
        DirectoryDialog dialog = new DirectoryDialog(this.shell, 4096);
        String file = dialog.open();
        if (file != null) {
            this.outputLabel.setText(file);
            this.preference.setValue("output", file);
        }
        this.checkOptimizeButton();
    }

    public void do_dobackup() {
        this.preference.setValue("dobackup", this.dobackup.getSelection());
    }

    public void do_optimizeButton() {
        this.optimizeButton.setEnabled(false);
        this.executing = true;
        String optiPngPath = this.optiPngLabel.getText();
        File optiPngFile = null;
        if (!optiPngPath.equals("") && !(optiPngFile = new File(optiPngPath)).exists()) {
            optiPngFile = null;
        }
        if (optiPngFile == null) {
            MessageBox dialog = new MessageBox(this.shell, 1);
            dialog.setText(Messages.getString("Error"));
            dialog.setMessage(Messages.getString("optipng_not_found"));
            dialog.open();
            this.optimizeButton.setEnabled(true);
        } else {
            this.executer = new OptiPNGExecuter();
            this.executer.setOptipngPath(optiPngFile.getAbsolutePath());
            this.executer.setLevel(this.level.getText());
            this.executer.setDoBackup(this.dobackup.getSelection());
            this.executer.setBackupExtension(".bk");
            this.executer.setTimeKeep(this.keepmodified.getSelection());
            if (this.outputLabel.getText().length() > 0 && !this.sameoutput.getSelection()) {
                this.executer.setOutput(new File(this.outputLabel.getText()));
            }
            FileListImageView fileListImageView = (FileListImageView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(FileListImageView.ID_VIEW);
            String[] files = fileListImageView.getFileListImage().getFileListTable().getFiles();
            int i = 0;
            while (i < files.length) {
                this.executer.addFile(files[i]);
                ++i;
            }
            IWorkbench workbench = PlatformUI.getWorkbench();
            WorkbenchWindow workbenchWindow = (WorkbenchWindow)workbench.getActiveWorkbenchWindow();
            StatusLineManager lineManager = workbenchWindow.getStatusLineManager();
            this.monitor = lineManager.getProgressMonitor();
            this.executer.setOptimizeListener(this);
            this.maxprogress = files.length;
            this.currentprogress = 0;
            this.monitor.beginTask(Messages.getString("optimize_png_file"), this.maxprogress);
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    public void do_table1() {
        System.out.println("table1");
    }

    public void do_menu1() {
        System.out.println("menu1");
    }

    public void do_addFileMenu() {
        System.out.println("addFileMenu");
    }

    public void do_addFolderMenu() {
        System.out.println("addFolderMenu");
    }

    public void do_level() {
        this.preference.setValue("level", "" + this.level.getSelectionIndex());
    }

    public void do_optiPngButton() {
        FileDialog dialog = new FileDialog(this.shell, 4096);
        String[] filename = new String[]{"optipng.exe"};
        dialog.setFilterExtensions(filename);
        String path = dialog.open();
        if (path != null) {
            this.optiPngLabel.setText(path);
            this.preference.setValue("optipng_path", path);
        }
    }

    public void removeList(FileStatusChangeEvent event) {
        this.checkOptimizeButton();
    }

    private void checkOptimizeButton() {
        FileListImageView fileListImageView = (FileListImageView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(FileListImageView.ID_VIEW);
        if (!this.executing) {
            if (fileListImageView.getFileListImage().getFileListTable().getFileCount() > 0 && (this.sameoutput.getSelection() || this.outputLabel.getText().length() > 0)) {
                this.optimizeButton.setEnabled(true);
            } else {
                this.optimizeButton.setEnabled(false);
            }
        } else {
            this.optimizeButton.setEnabled(false);
        }
    }

    public void addList(FileStatusChangeEvent event) {
        this.checkOptimizeButton();
    }

    public void optimizeEnd(File input, File output, long preSize, long endSize) {
        ++this.currentprogress;
        this.shell.getDisplay().syncExec((Runnable)new OptimizeEnd(this.currentprogress));
        System.out.println(this.currentprogress);
    }

    public void optimizeStart(File input, File output) {
        this.shell.getDisplay().syncExec((Runnable)new OptimizeStart(input.getName()));
    }

    public class wakeUpper
    extends Thread {
        public void run() {
            DoWake wake = new DoWake();
            while (OptipngWrapperView.this.executing) {
                OptipngWrapperView.this.shell.getDisplay().wake();
                System.out.println("waveup");
                OptipngWrapperView.this.shell.getDisplay().asyncExec((Runnable)wake);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public class DoWake
    implements Runnable {
        public void run() {
            System.out.println("read1");
            OptipngWrapperView.this.shell.getDisplay().readAndDispatch();
            System.out.println("read2");
        }
    }

    public class CreateResultDialog
    implements Runnable {
        private ResultData[] data;

        CreateResultDialog(ResultData[] data) {
            this.data = data;
        }

        public void run() {
            ResultView resultView = (ResultView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(ResultView.ID_VIEW);
            resultView.setResultData(this.data);
            OptipngWrapperView.this.optimizeButton.setEnabled(true);
            OptipngWrapperView.this.monitor.done();
        }
    }

    public class DropMonitor
    extends DropTargetAdapter {
        public void dragEnter(DropTargetEvent event) {
        }

        public void dragOver(DropTargetEvent event) {
        }

        public void drop(DropTargetEvent event) {
            String[] files = (String[])event.data;
            int i = 0;
            while (i < files.length) {
                File file = new File(files[i]);
                if (file.isDirectory()) {
                    OptipngWrapperView.this.outputLabel.setText(files[i]);
                }
                ++i;
            }
        }
    }

    public class OptimizeEnd
    implements Runnable {
        int current;

        public OptimizeEnd(int current) {
            this.current = current;
        }

        public void run() {
            OptipngWrapperView.this.monitor.worked(this.current);
        }
    }

    public class OptimizeStart
    implements Runnable {
        String name;

        public OptimizeStart(String name) {
            this.name = name;
        }

        public void run() {
            OptipngWrapperView.this.monitor.subTask(this.name);
        }
    }
}

