/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.jsapi;

import com.sun.speech.engine.BaseEngineProperties;
import com.sun.speech.engine.synthesis.BaseSynthesizer;
import com.sun.speech.engine.synthesis.BaseSynthesizerProperties;
import com.sun.speech.engine.synthesis.BaseSynthesizerQueueItem;
import com.sun.speech.engine.synthesis.BaseVoice;
import com.sun.speech.freetts.OutputQueue;
import com.sun.speech.freetts.Voice;
import com.sun.speech.freetts.audio.AudioPlayer;
import com.sun.speech.freetts.audio.JavaClipAudioPlayer;
import com.sun.speech.freetts.jsapi.FreeTTSSynthesizerModeDesc;
import com.sun.speech.freetts.jsapi.FreeTTSSynthesizerQueueItem;
import com.sun.speech.freetts.jsapi.FreeTTSVoice;
import java.beans.PropertyVetoException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.speech.EngineException;
import javax.speech.EngineStateError;
import javax.speech.synthesis.SynthesizerModeDesc;

public class FreeTTSSynthesizer
extends BaseSynthesizer {
    OutputHandler outputHandler = new OutputHandler();
    private FreeTTSVoice curVoice;
    private AudioPlayer audio;
    private OutputQueue outputQueue;

    public FreeTTSSynthesizer(FreeTTSSynthesizerModeDesc desc) {
        super(desc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleAllocate() throws EngineException {
        long[] states;
        boolean ok = false;
        FreeTTSSynthesizerModeDesc desc = (FreeTTSSynthesizerModeDesc)this.getEngineModeDesc();
        this.outputQueue = Voice.createOutputThread();
        if (desc.getVoices().length > 0) {
            FreeTTSVoice freettsVoice = (FreeTTSVoice)desc.getVoices()[0];
            ok = this.setCurrentVoice(freettsVoice);
        }
        if (ok) {
            Object object = this.engineStateLock;
            synchronized (object) {
                long newState = 516L;
                states = this.setEngineState(-1L, newState |= this.outputHandler.isQueueEmpty() ? 65536L : 131072L);
            }
        } else {
            throw new EngineException("Can't allocate FreeTTS synthesizer");
        }
        this.outputHandler.start();
        this.postEngineAllocated(states[0], states[1]);
    }

    private boolean setCurrentVoice(FreeTTSVoice voice) throws EngineException {
        Voice freettsVoice = voice.getVoice();
        boolean ok = false;
        if (!freettsVoice.isLoaded()) {
            freettsVoice.setOutputQueue(this.outputQueue);
            freettsVoice.allocate();
            this.audio = freettsVoice.getAudioPlayer();
            if (this.audio == null) {
                this.audio = new JavaClipAudioPlayer();
            }
            if (this.audio == null) {
                throw new EngineException("Can't get audio player");
            }
            freettsVoice.setAudioPlayer(this.audio);
        }
        if (freettsVoice.isLoaded()) {
            this.curVoice = voice;
            ok = true;
            FreeTTSSynthesizerProperties props = (FreeTTSSynthesizerProperties)this.getSynthesizerProperties();
            props.checkForPropertyChanges();
        }
        return ok;
    }

    protected void handleDeallocate() throws EngineException {
        long[] states = this.setEngineState(-1L, 1L);
        this.outputHandler.cancelAllItems();
        this.outputHandler.terminate();
        if (this.audio != null) {
            this.audio.close();
        }
        this.outputQueue.close();
        this.postEngineDeallocated(states[0], states[1]);
    }

    protected BaseSynthesizerQueueItem createQueueItem() {
        return new FreeTTSSynthesizerQueueItem();
    }

    public Enumeration enumerateQueue() throws EngineStateError {
        this.checkEngineState(9L);
        return this.outputHandler.enumerateQueue();
    }

    protected void appendQueue(BaseSynthesizerQueueItem item) {
        this.outputHandler.appendQueue((FreeTTSSynthesizerQueueItem)item);
    }

    public void cancel() throws EngineStateError {
        this.checkEngineState(9L);
        this.outputHandler.cancelItem();
    }

    public void cancel(Object source) throws IllegalArgumentException, EngineStateError {
        this.checkEngineState(9L);
        this.outputHandler.cancelItem(source);
    }

    public void cancelAll() throws EngineStateError {
        this.checkEngineState(9L);
        this.outputHandler.cancelAllItems();
    }

    protected void handlePause() {
        this.audio.pause();
    }

    protected void handleResume() {
        this.audio.resume();
    }

    protected BaseEngineProperties createEngineProperties() {
        SynthesizerModeDesc desc = (SynthesizerModeDesc)this.engineModeDesc;
        FreeTTSVoice defaultVoice = (FreeTTSVoice)desc.getVoices()[0];
        return new FreeTTSSynthesizerProperties(defaultVoice, defaultVoice.getPitch(), defaultVoice.getPitchRange(), defaultVoice.getSpeakingRate(), defaultVoice.getVolume());
    }

    class OutputHandler
    extends Thread {
        protected boolean done = false;
        protected Vector queue = new Vector();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void terminate() {
            Vector vector = this.queue;
            synchronized (vector) {
                this.done = true;
                this.queue.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Enumeration enumerateQueue() {
            Vector vector = this.queue;
            synchronized (vector) {
                return this.queue.elements();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isQueueEmpty() {
            Vector vector = this.queue;
            synchronized (vector) {
                return this.queue.size() == 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void appendQueue(FreeTTSSynthesizerQueueItem item) {
            boolean topOfQueueChanged;
            Vector vector = this.queue;
            synchronized (vector) {
                topOfQueueChanged = this.queue.size() == 0;
                this.queue.addElement(item);
                this.queue.notifyAll();
            }
            if (topOfQueueChanged) {
                long[] states = FreeTTSSynthesizer.this.setEngineState(65536L, 131072L);
                FreeTTSSynthesizer.this.postQueueUpdated(topOfQueueChanged, states[0], states[1]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void cancelItem() {
            FreeTTSSynthesizerQueueItem item = null;
            Vector vector = this.queue;
            synchronized (vector) {
                FreeTTSSynthesizer.this.audio.cancel();
                if (this.queue.size() != 0 && (item = (FreeTTSSynthesizerQueueItem)this.queue.remove(0)) != null) {
                    item.cancelled();
                    this.queueDrained();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void cancelAllItems() {
            Vector copy;
            FreeTTSSynthesizerQueueItem item = null;
            Vector vector = this.queue;
            synchronized (vector) {
                FreeTTSSynthesizer.this.audio.cancel();
                copy = (Vector)this.queue.clone();
                this.queue.clear();
                this.queueDrained();
            }
            Iterator i = copy.iterator();
            while (i.hasNext()) {
                item = (FreeTTSSynthesizerQueueItem)i.next();
                item.cancelled();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void cancelItem(Object source) {
            FreeTTSSynthesizerQueueItem item = null;
            Vector vector = this.queue;
            synchronized (vector) {
                int index = this.queue.indexOf(source);
                if (index == 0) {
                    this.cancelItem();
                } else {
                    item = (FreeTTSSynthesizerQueueItem)this.queue.remove(index);
                    if (item != null) {
                        item.cancelled();
                        this.queueDrained();
                    }
                }
            }
        }

        public void run() {
            while (!this.done) {
                FreeTTSSynthesizerQueueItem item = this.getQueueItem();
                if (item == null) continue;
                this.outputItem(item);
                this.removeQueueItem(item);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected FreeTTSSynthesizerQueueItem getQueueItem() {
            FreeTTSSynthesizerQueueItem item = null;
            Vector vector = this.queue;
            synchronized (vector) {
                while (this.queue.size() == 0 && !this.done) {
                    try {
                        this.queue.wait();
                    }
                    catch (InterruptedException e) {
                        this.error("Unexpected interrupt");
                    }
                }
                if (this.done) {
                    return null;
                }
                item = (FreeTTSSynthesizerQueueItem)this.queue.elementAt(0);
            }
            item.postTopOfQueue();
            return item;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void removeQueueItem(FreeTTSSynthesizerQueueItem item) {
            boolean queueEmptied = false;
            Vector vector = this.queue;
            synchronized (vector) {
                boolean found = this.queue.remove(item);
                if (found) {
                    this.queueDrained();
                }
            }
        }

        private void queueDrained() {
            if (this.queue.size() == 0) {
                long[] states = FreeTTSSynthesizer.this.setEngineState(131072L, 65536L);
                FreeTTSSynthesizer.this.postQueueEmptied(states[0], states[1]);
            } else {
                long[] states = FreeTTSSynthesizer.this.setEngineState(131072L, 131072L);
                FreeTTSSynthesizer.this.postQueueUpdated(true, states[0], states[1]);
            }
        }

        protected void outputItem(FreeTTSSynthesizerQueueItem item) {
            Voice voice = FreeTTSSynthesizer.this.curVoice.getVoice();
            voice.speak(item);
        }

        private void error(String s) {
            System.out.println("Error: " + s);
        }

        private void trace(String s) {
            System.out.println("Trace: " + s);
        }
    }

    class FreeTTSSynthesizerProperties
    extends BaseSynthesizerProperties {
        FreeTTSSynthesizerProperties(BaseVoice defaultVoice, float defaultPitch, float defaultPitchRange, float defaultSpeakingRate, float defaultVolume) {
            super(defaultVoice, defaultPitch, defaultPitchRange, defaultSpeakingRate, defaultVolume);
        }

        public void reset() {
            super.reset();
        }

        void checkForPropertyChanges() {
            try {
                float speakingRate;
                float volume;
                float pitchRange;
                float pitch = this.getPitch();
                if (pitch != this.currentPitch) {
                    super.setPitch(pitch);
                }
                if ((pitchRange = this.getPitchRange()) != this.currentPitchRange) {
                    super.setPitchRange(pitchRange);
                }
                if ((volume = this.getVolume()) != this.currentVolume) {
                    super.setVolume(volume);
                }
                if ((speakingRate = this.getSpeakingRate()) != this.currentSpeakingRate) {
                    super.setSpeakingRate(speakingRate);
                }
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }

        public float getPitch() {
            Voice voice = FreeTTSSynthesizer.this.curVoice.getVoice();
            return voice.getPitch();
        }

        public void setVoice(javax.speech.synthesis.Voice voice) {
            if (!FreeTTSSynthesizer.this.curVoice.match(voice)) {
                FreeTTSSynthesizerModeDesc desc = (FreeTTSSynthesizerModeDesc)FreeTTSSynthesizer.this.getEngineModeDesc();
                javax.speech.synthesis.Voice[] voices = desc.getVoices();
                for (int i = 0; i < voices.length; ++i) {
                    if (!voices[i].match(voice)) continue;
                    try {
                        if (!FreeTTSSynthesizer.this.setCurrentVoice((FreeTTSVoice)voices[i])) continue;
                        try {
                            super.setVoice(voice);
                            break;
                        }
                        catch (PropertyVetoException pve) {
                            continue;
                        }
                    }
                    catch (EngineException ee) {
                        System.err.println("Engine Exception: " + ee.getMessage());
                    }
                }
            }
        }

        public void setPitch(float hertz) throws PropertyVetoException {
            if (hertz != this.getPitch()) {
                Voice voice = FreeTTSSynthesizer.this.curVoice.getVoice();
                voice.setPitch(hertz);
                super.setPitch(hertz);
            }
        }

        public float getPitchRange() {
            Voice voice = FreeTTSSynthesizer.this.curVoice.getVoice();
            return voice.getPitchRange();
        }

        public void setPitchRange(float hertz) throws PropertyVetoException {
            if (hertz != this.getPitchRange()) {
                Voice voice = FreeTTSSynthesizer.this.curVoice.getVoice();
                voice.setPitchRange(hertz);
                super.setPitchRange(hertz);
            }
        }

        public float getSpeakingRate() {
            Voice voice = FreeTTSSynthesizer.this.curVoice.getVoice();
            return voice.getRate();
        }

        public void setSpeakingRate(float wpm) throws PropertyVetoException {
            if (wpm != this.getSpeakingRate()) {
                Voice voice = FreeTTSSynthesizer.this.curVoice.getVoice();
                voice.setRate(wpm);
                super.setSpeakingRate(wpm);
            }
        }

        public float getVolume() {
            Voice voice = FreeTTSSynthesizer.this.curVoice.getVoice();
            return voice.getVolume();
        }

        public void setVolume(float volume) throws PropertyVetoException {
            if (volume > 1.0f) {
                volume = 1.0f;
            } else if (volume < 0.0f) {
                volume = 0.0f;
            }
            if (volume != this.getVolume()) {
                Voice voice = FreeTTSSynthesizer.this.curVoice.getVoice();
                voice.setVolume(volume);
                super.setVolume(volume);
            }
        }
    }
}

