#include "MTCH6102.h"

#define ADDR 0x25

//neopixel
#include <Adafruit_NeoPixel.h>
#ifdef __AVR__
  #include <avr/power.h> // Required for 16 MHz Adafruit Trinket
#endif
#define PIN        8 // On Trinket or Gemma, suggest changing this to 1
#define NUMPIXELS 8 // Popular NeoPixel ring size
Adafruit_NeoPixel pixels(NUMPIXELS, PIN, NEO_GRB + NEO_KHZ800);
#define DELAYVAL 500 // Time (in milliseconds) to pause between pixels

//speaker
#define SPIN A1

MTCH6102 mtch = MTCH6102();

const int len = 8;//感知ポイント数
bool sound = false;

void setup() {
  Serial.begin(115200);

  mtch.begin(ADDR);
  delay(100);
  mtch.writeRegister(MTCH6102_NUMBEROFXCHANNELS, 0x07);
  mtch.writeRegister(MTCH6102_NUMBEROFYCHANNELS, 0x03);//最低3点必要なため
  mtch.writeRegister(MTCH6102_MODE, MTCH6102_MODE_FULL);
  delay(500);

  //neopixel
#if defined(__AVR_ATtiny85__) && (F_CPU == 16000000)
  clock_prescale_set(clock_div_1);
#endif
  pixels.begin(); // INITIALIZE NeoPixel strip object (REQUIRED)

  //speaker
  tone(SPIN, 440);
  delay(500);
  noTone(SPIN);
}


void loop() {

  pixels.clear(); // Set all pixel colors to 'off'

  sound = false;
  byte data;
  int sensVals[len];

  Serial.println();
  for (int i = 0; i < len; i++) {
    data = mtch.readRegister(MTCH6102_SENSORVALUE_RX0 + i);
    Serial.print(data);
    Serial.print(",");    sensVals[i] = data;
    sensVals[i] = data;
    if (data > 50) {
      pixels.setPixelColor(i, pixels.Color(0, 10, 0));
      sound = true;    
    }
    if(sound){
      tone(SPIN, 440);
    }else{
      noTone(SPIN);
    }
  }


  pixels.show();   // Send the updated pixel colors to the hardware.

  delay(10);
}
