#include <LovyanGFX.hpp>
struct LGFX_Config
{
  static constexpr spi_host_device_t spi_host = VSPI_HOST;
  static constexpr int dma_channel = 1;
  static constexpr int spi_sclk = 18;
  static constexpr int spi_mosi = 23;
  static constexpr int spi_miso = 19;
  static constexpr int spi_dlen = 8;
};
static lgfx::LGFX_SPI<LGFX_Config> lcd;
static lgfx::Panel_ILI9341 panel;

void setup(void)
{
  panel.freq_write = 20000000;
  panel.freq_fill  = 27000000;
  panel.freq_read  = 16000000;
  panel.spi_mode = 0;
  panel.spi_mode_read = 0;
  panel.len_dummy_read_pixel = 8;
  panel.spi_read = true;
  panel.spi_3wire = false;
  panel.spi_cs = 5;
  panel.spi_dc = 17;
  panel.gpio_rst = 16;
  panel.gpio_bl  = 4;
  panel.pwm_ch_bl = ;
  panel.backlight_level = true;
  panel.reverse_invert = false;
  panel.rgb_order = false;
  panel.memory_width  = 240;
  panel.memory_height = 320;
  panel.panel_width  = 240;
  panel.panel_height = 320;
  panel.offset_x = 0;
  panel.offset_y = 0;
  panel.rotation = 0;
  panel.offset_rotation = 0;
  lcd.setPanel(&panel);
  lcd.init();
}

uint32_t count = ~0;
void loop(void)
{
  for ( int i=0; i<4;i++){
    lcd.setRotation(i);
    lcd.startWrite();
    lcd.fillScreen(random(65535));
    lcd.setCursor(0,0);
    lcd.setFont(&lgfxJapanGothicP_8); lcd.setTextColor(random(65535),random(65535)); lcd.print("縦 8日本語\n");
    lcd.setFont(&lgfxJapanGothicP_12);lcd.setTextColor(random(65535),random(65535)); lcd.print("縦12日本語\n");
    lcd.setFont(&lgfxJapanGothicP_16); lcd.setTextColor(random(65535),random(65535));lcd.print("縦16日本語\n");
//    lcd.setFont(&lgfxJapanGothicP_20); lcd.setTextColor(random(65535),random(65535));lcd.print("縦20日本語\n");
//    lcd.setFont(&lgfxJapanGothicP_24); lcd.setTextColor(random(65535),random(65535));lcd.print("縦24日本語\n");
//    lcd.setFont(&lgfxJapanGothicP_28); lcd.setTextColor(random(65535),random(65535));lcd.print("縦28日本語\n");
//    lcd.setFont(&lgfxJapanGothicP_32); lcd.setTextColor(random(65535),random(65535));lcd.print("縦32日本語\n");
//    lcd.setFont(&lgfxJapanGothicP_36); lcd.setTextColor(random(65535),random(65535));lcd.print("縦36日本語\n");
    lcd.setFont(&lgfxJapanGothicP_40);lcd.setTextColor(random(65535),random(65535)); lcd.print("縦40日本語\n");
    lcd.endWrite();
    delay(3000);
  }
}
