
#include <LovyanGFX.hpp>
#include <SPIFFS.h>
#include <FS.h>
struct LGFX_Config
{
  static constexpr spi_host_device_t spi_host = VSPI_HOST;
  static constexpr int dma_channel = 1;
  static constexpr int spi_sclk = 18;
  static constexpr int spi_mosi = 23;
  static constexpr int spi_miso = 19;
  static constexpr int spi_dlen = 8;
};
static lgfx::LGFX_SPI<LGFX_Config> tft;
static lgfx::Panel_ILI9341 panel;
const char* recordfile = "/timerecord.txt";

void setup() {
  Serial.begin(115200);
  Serial.println("OZONCONTROLLER START");

  panel.freq_write = 20000000;
  panel.freq_fill  = 27000000;
  panel.freq_read  = 16000000;
  panel.spi_mode = 0;
  panel.spi_mode_read = 0;
  panel.len_dummy_read_pixel = 8;
  panel.spi_read = true;
  panel.spi_3wire = false;
  panel.spi_cs = 5;
  panel.spi_dc = 17;
  panel.gpio_rst = 16;
  panel.gpio_bl  = 4;
  panel.pwm_ch_bl = 7;
  panel.backlight_level = true;
  panel.reverse_invert = false;
  panel.rgb_order = false;
  panel.memory_width  = 240;
  panel.memory_height = 320;
  panel.panel_width  = 240;
  panel.panel_height = 320;
  panel.offset_x = 0;
  panel.offset_y = 0;
  panel.rotation = 0;
  panel.offset_rotation = 0;
  tft.setPanel(&panel);
  tft.init();



  //  Serial.print(F("Rectangles (filled)      "));
  //  Serial.println(testFilledRects(TFT_WHITE, TFT_BLUE));
  //  delay(500);

  
  //   init filesystem
  bool res = SPIFFS.begin(true); // FORMAT_SPIFFS_IF_FAILED
  if (!res) {
      Serial.println("SPIFFS.begin fail");
  }
  Serial.println("SPIFFS.begin OK");

  File fp = SPIFFS.open(recordfile, "w");
  fp.println(12345);
/*  fp.println(oneshot_Ozonelevel);
  fp.println(oneshot_endtime);
  fp.println(program_Ozonelevel);
  fp.println(program_starttime);
  fp.println(program_endtime);
  fp.println(log_pump);
  fp.println(log_ozone);
  fp.println(log_fan);
  fp.println(log_oncount); */
  fp.close();

  /*
  // set file read
  fp = SPIFFS.open(recordfile, "r");
  if (!fp) {
      Serial.println("open error");
  }
  int temp = fp.readStringUntil('\n').toInt();
  Serial.println(temp);
  Serial.println("----------------------------------------------------------------------------------------");
*/
//  oneshot_Ozonelevel = fp.readStringUntil('\n').toInt();
/*  oneshot_endtime = fp.readStringUntil('\n');
  program_Ozonelevel = fp.readStringUntil('\n');
  program_starttime = fp.readStringUntil('\n');
  program_endtime = fp.readStringUntil('\n');
  Serial.print("oneshot_Ozonelevel:");
  Serial.println(oneshot_Ozonelevel);
  Serial.print("oneshot_endtime:");
  Serial.println(oneshot_endtime);
  Serial.print("program_Ozonelevel:");
  Serial.println(program_Ozonelevel);
  Serial.print("program_starttime:");
  Serial.println(program_starttime);
  Serial.print("program_endtime:");
  Serial.println(program_endtime);
  Serial.print("log_pump:");
  Serial.println(log_pump);
  Serial.print("log_ozone:");
  Serial.println(log_ozone);
  Serial.print("log_fan:");
  Serial.println(log_fan);
  Serial.print("log_oncount:");
  Serial.println(log_oncount);
  fp.close();


*/




}
void loop() {
  // put your main code here, to run repeatedly:

}
