#include "MTCH6102.h"

#define ADDR 0x25

//neopixel
#include <Adafruit_NeoPixel.h>
#ifdef __AVR__
  #include <avr/power.h> // Required for 16 MHz Adafruit Trinket
#endif
#define PIN        8 // On Trinket or Gemma, suggest changing this to 1
#define NUMPIXELS 8 // Popular NeoPixel ring size
Adafruit_NeoPixel pixels(NUMPIXELS, PIN, NEO_GRB + NEO_KHZ800);
#define DELAYVAL 500 // Time (in milliseconds) to pause between pixels

//speaker
#define SPIN A1

MTCH6102 mtch = MTCH6102();

const int len = 8;//感知ポイント数
bool sound = false;

void setup() {
  Serial.begin(115200);
  mtch.begin(ADDR);
  delay(100);
  mtch.writeRegister(MTCH6102_NUMBEROFXCHANNELS, 0x07);
  mtch.writeRegister(MTCH6102_NUMBEROFYCHANNELS, 0x03);//最低3点必要なため
  mtch.writeRegister(MTCH6102_MODE, MTCH6102_MODE_FULL);
  delay(500);


  //neopixel

  //speaker
  tone(SPIN, 440);
  delay(500);
  noTone(SPIN);
  delay(1000);
}


void loop() {

  Serial.println();
  for (int i = 0; i < 16; i++) {
    Serial.print(i);
    Serial.print(",");
  }
  delay(10);
}
