
#include <RotaryEncoder.h>

#define ENCODER1_A_PIN 34
#define ENCODER1_B_PIN 35
#define ENCODER1_SWITCH_PIN 25
#define ENCODER2_A_PIN 12
#define ENCODER2_B_PIN 13
#define ENCODER2_SWITCH_PIN 14


RotaryEncoder encoder1(ENCODER1_A_PIN,ENCODER1_B_PIN);
RotaryEncoder encoder2(ENCODER2_A_PIN,ENCODER2_B_PIN);

static int encoder1Pushed=0;   // you must turn 0 after button check
static int encoder1Pushing=0;
static int encoder2Pushed=0;   // you must turn 0 after button check
static int encoder2Pushing=0;


hw_timer_t * timer = NULL;

void IRAM_ATTR onTimer() {  // each 20msec
//  encoder2.tick(); // just call tick() to check the state.
//  encoder1.tick(); // just call tick() to check the state.

}

void IRAM_ATTR ISR() {
  encoder2.tick(); // just call tick() to check the state.
  encoder1.tick(); // just call tick() to check the state.
  
}

void IRAM_ATTR RELEASE1() {
  static unsigned long nowtime;
  static unsigned long oldtime=0;
  int value1=digitalRead(ENCODER1_SWITCH_PIN);
  Serial.println();
  Serial.print(":");
  Serial.println(value1);
  nowtime=millis();
  if ( 150 < ( nowtime - oldtime )){
  Serial.print("released1!!!!!!!!!!");
  Serial.print(oldtime);
  Serial.print("  ");
  Serial.println(nowtime);
  }
  oldtime=nowtime;  
}
void IRAM_ATTR RELEASE2() {
  static unsigned long nowtime;
  static unsigned long oldtime=0;
  int value2=digitalRead(ENCODER2_SWITCH_PIN);
  Serial.println("");
  Serial.print(":");
  Serial.print(value2);
  nowtime=millis();
  if ( 500 < ( nowtime - oldtime )){
  Serial.print("released2!!!!!!!!!!");
  Serial.print(oldtime);
  Serial.print("  ");
  Serial.println(nowtime);
  }    
  oldtime=nowtime; 
}
void setup()
{
  Serial.begin(115200);
  pinMode(ENCODER1_SWITCH_PIN,INPUT_PULLUP);
  pinMode(ENCODER2_SWITCH_PIN,INPUT_PULLUP);

  
  Serial.println("SimplePollRotator example for the RotaryEncoder library.");
  attachInterrupt(ENCODER1_A_PIN, ISR, CHANGE);   // rotary_encoder
  attachInterrupt(ENCODER1_B_PIN, ISR, CHANGE);   // rotary_encoder
  attachInterrupt(ENCODER1_SWITCH_PIN, RELEASE1, RISING);  // rotary_encoder push switch
  attachInterrupt(ENCODER2_A_PIN, ISR, CHANGE);   // rotary_encoder
  attachInterrupt(ENCODER2_B_PIN, ISR, CHANGE);   // rotary_encoder
  attachInterrupt(ENCODER2_SWITCH_PIN, RELEASE2, RISING);  // rotary_encoder push switch
  timer = timerBegin(0, 80, true);
  timerAttachInterrupt(timer, &onTimer, true);
  timerAlarmWrite(timer, 20000, true);  // 20m sec
  timerAlarmEnable(timer);
} // setup()


// Read the current position of the encoder and print out when changed.
void loop()
{

  static int pos = 0;

  int newPos1 = encoder1.getPosition();
  int newPos2 = encoder2.getPosition();
  Serial.print(" ");
  Serial.print(newPos1);
  Serial.print(" ");
  Serial.print(newPos2);
  Serial.print(" ");
  Serial.print(" ");
      delay(400);

      
} // loop ()

// The End
