#include <akaxiso/akaxiso.h>
#include <akaxiso/content_model.h>
#include <iostream>

namespace {

  struct chars {
    std::string encoding_;
    std::string text_;
  };

  struct chars_leaf : public aka::sequence<chars, chars_leaf> {
    void model() {
      member("encoding", &chars::encoding_);
      member("text", &chars::text_);
    }
  };

}

void parse(const std::string &filename, const std::string &encoding) {

#ifdef USE_XERCESC
  {
    aka::use_xerces_transcoder(true); // If USE_XERCESC is defined, Default is true.
                                      // You don't have to specify.
    std::cout << std::endl
	      << "Using Xerces-C++ transcoder..." << std::endl
	      << std::endl;

    aka::use_xerces_transcoder(true);
    aka::xerces_parser parser;
    aka::document doc = parser.parse_file(filename);
    
    aka::xml_serializer ser(encoding);
    ser.serialize(doc, std::cout);
    aka::use_xerces_transcoder(false);
  }
#endif

  {
    std::cout << std::endl
	      << "Using babel translator..." << std::endl
	      << std::endl;
    aka::yggxml_parser parser;
    aka::document doc = parser.parse_file(filename);
    aka::xml_serializer ser(encoding);
    ser.serialize(doc, std::cout);
  }

}


void usage() {
  std::cout << "encoding [filename] [encoding]" << std::endl
            << "  -h : show this usage." << std::endl;
}


int main(int argc, const char* argv[]){
  
  aka::initialize();
  aka::doctype("chars", chars_leaf());

  if (argc != 3) {
    usage();
    return 1;
  }

  parse(argv[1], argv[2]);

  aka::uninitialize();
  return 0;
}
