/* -*- c++ -*- */
#ifndef AKAXISO_XML_SERIALIZER_H__
#define AKAXISO_XML_SERIALIZER_H__

#include <akaxiso/serializer.h>

namespace aka2 {

  class xml_serializer : public serializer {
  public:
    xml_serializer(const std::string &encoding = DEFAULT_CHARSET)
      : serializer(2, encoding), gattrs_(system_global_attributes()) {};
    virtual ~xml_serializer();

  private:
    virtual void serialize_internal(const void *root, const qname &name,
                                    const element_op &op);

    void write_element(const qname &tagname,
                       const void *e, const element_op &op, bool is_root);
    void write_element_entity(const void *e, const element_op &op);
    void write_content(const void *e, const element_op &op);

    void write_sequence(const qname &tagname,
                        const void *e, const sequence_op &sop,
                        bool is_root);
    void write_sequence_entity(const void *e, const sequence_op &sop);

    void write_choice(const qname &tagname, 
                      const void *e, const choice_op &sop,
                      bool is_root);
    void write_choice_entity(const void *e, const choice_op &sop);

    void write_all(const qname &tagname,
                   const void *e, const all_op &sop,
                   bool is_root);
    void write_all_entity(const void *e, const all_op &sop);

    void write_simplecontent(const qname &tagname, 
                             const void *e, const simplecontent_op &sop,
                             bool is_root);

    void write_array(const qname& tagname,
                     const void *e, const array_op &sop);
    void write_group_array(const void *e, const array_op &sop);

    void write_simpletype(const qname &tagname,
                          const void *e, const simpletype_op &sop,
                          bool is_root);

    void write_nill_element(const qname &tagname, 
                            const void *e, const element_op &op,
                            bool is_root);
    void write_beginning_tag(const qname& tagname,
                             const void *e, const element_op &op,
                             bool is_root);
    void write_ending_tag(const qname &tagname);

    void write_attributes(const void *e, const element_op &op);
    void write_namespace_attributes();

    const global_attributes &gattrs_;
  };

} // namespace aka2

#endif /* AKAXISO_XML_SERIALIZER_H__ */
