/* -*- c++ -*- */
#include "document.h"

namespace aka2 {

void document_factory::register_document_type(const qname &docname, 
                                              const element_op& op,
                                              const occurrence &occurs){
  doctype_map_.insert(doctype_map::value_type(docname, docdef(&op, occurs)));
}

document document_factory::create_named_document(const qname &docname){
  doctype_map::iterator it = doctype_map_.find(docname);
  if (it == doctype_map_.end()) {
    std::string errmsg = "Document(" + docname.qualified() + ") not found.";
    throw parse_exception(__FILE__, __LINE__, errmsg.c_str());
  }
  void* root = it->second.op_->create();

  return document(docname, root, it->second);
}

const docdef* document_factory::get_docdef(const qname &docname) const {
  doctype_map::const_iterator it = doctype_map_.find(docname);
  return it == doctype_map_.end() ? 0 : &it->second;
}

bool aka2::document_of(const aka2::document &i, const std::string &tagname) {
  return aka2::qname(tagname) == i.get_name();
}

} // namespace aka2
