/* -*- c++ -*- */
#ifndef AKAXISO_CLASSES_ANY_H__
#define AKAXISO_CLASSES_ANY_H__

#include <akaxiso/classes/traits.h>
#include <akaxiso/classes/membertype.h>
#include <akaxiso/classes/any_attributes.h>


namespace aka2 {

  struct any {
    qname tagname_;
    wc_attributes attributes_;
    std::string value_;
    std::vector<any> children_; 
  };


  class any_op : public element_op {
  public:
    virtual schematype_id get_schematype() const { return any_id; }
    virtual const qname& get_typename() const { return typename_; }
    
    /** creatable */
    virtual void* create() const { return new any; }
    virtual void destroy(void *elm) const { delete static_cast<any*>(elm); }
    virtual bool equals(const void *lhs, const void *rhs) const;
    virtual void copy(void *dest, const void *src) const;
    
    /** attribute_types getter. */
    virtual const attribute_types *get_attribute_types() const { 
      assert(!"Must not be called.");
      return 0; 
    }
    virtual const any_member *get_anyattr_type() const {
      assert(!"Must not be called.");
      return 0; 
    }
    qname typename_;
    static any_op dispatcher_;
  };


  typedef std::vector<any> any_array; 

  class any_array_op : public element_op {
  public:
    virtual schematype_id get_schematype() const { return any_array_id; }
    virtual const qname& get_typename() const { return typename_; }
    
    /** creatable */
    virtual void* create() const { return new any; }
    virtual void destroy(void *elm) const { delete static_cast<any*>(elm); }
    virtual bool equals(const void *lhs, const void *rhs) const;
    virtual void copy(void *dest, const void *src) const;
    
    /** attribute_info getter. */
    virtual const attribute_types *get_attribute_types() const { 
      assert(!"Must not be called.");
      return 0; 
    }
    virtual const any_member *get_anyattr_type() const {
      assert(!"Must not be called.");
      return 0; 
    }

    qname typename_;
    static any_array_op dispatcher_;
  };

};

#endif
