/* -*- c++ -*- */
#include "akaxiso.h"
#include "formatter.h"
#include "classes/namespaces.h"
#include "classes/type_registory.h"
#include "classes/closure.h"

#ifdef USE_XERCESC
#include <xercesc/util/PlatformUtils.hpp> /* {Xerces-C++2.2} */
#endif

namespace aka2 {

namespace {
  namespace_map namespaces_;
  global_attributes gattrs_;
  document_factory docfactory_;
  type_registory type_registory_;
  int init_count_ = 0;
}

void aka2::use_xerces_transcoder(bool use) {
  formatter::use_xerces_transcoder_ = use;
}

global_attributes &aka2::system_global_attributes() {
  return gattrs_;
}

namespace_map & aka2::namespaces() {
  return namespaces_;
}

document_factory& aka2::system_document_factory() {
  return docfactory_;
} 

type_registory &aka2::system_type_registory() {
  return type_registory_;
}


void aka2::initialize() {

  ++init_count_;
  if (init_count_ != 1)
    return;

  babel::init_babel();

#ifdef USE_XERCESC
  xercesc::XMLPlatformUtils::Initialize();
  use_xerces_transcoder(true);
#endif

  namespaces_    .initialize();
  gattrs_        .initialize();
  docfactory_    .initialize();
  type_registory_.initialize();
  enclose_op    ::initialize();
  disclose_op   ::initialize();
}

void aka2::uninitialize() {

  --init_count_;
  if (init_count_ != 0)
    return;

  namespaces_    .uninitialize();
  gattrs_        .uninitialize();
  docfactory_    .uninitialize();
  type_registory_.uninitialize();

#ifdef USE_XERCESC
  xercesc::XMLPlatformUtils::Terminate();
#endif
}

} // namespace aka2
