/* -*- c++ -*- */
#ifndef AKAXISO_SCHEMADATATYPES_H__
#define AKAXISO_SCHEMADATATYPES_H__

#include <akaxiso/akaxiso.h>

namespace xml_schema {


#  define NS_XMLSCHEMA "http://www.w3.org/2001/XMLSchema"

  struct xsd{
    const char *uri() const { return NS_XMLSCHEMA; } 
    const char *prefix() const { return "xsd"; }
  };

  /** Exception for wrong schema element. */
  struct wrong_grammer{};

  class Pattern : public akaxiso::simplecontent_impl<Pattern, 
		  akaxiso::null_value> {
  public:
    static void initialize_types() {
      static_typeinfo().set_typename("xsd:pattern");
      define_attribute("value", &Pattern::value_);
    }

    std::string value_;
  };


  class Enumeration : public akaxiso::simplecontent_impl<Enumeration, 
		      akaxiso::null_value> {
  public:
    static void initialize_types() {
      static_typeinfo().set_typename("xsd:enumeration");
      define_attribute("value", &Enumeration::value_);
    }
    std::string value_;
  };

}


#endif
