#include "parser.h"
#include "xerces_handler.h"
#include <assert.h>
using namespace akaxiso;

#ifndef USE_XERCESC

xerces_parser::xerces_parser() {
  assert(!"Configuration does not include the use of Xerces-c");
}


#else

#include <xercesc/framework/MemBufInputSource.hpp>
#include <xercesc/framework/StdInInputSource.hpp>
#include <xercesc/sax2/SAX2XMLReader.hpp>
#include <xercesc/sax2/XMLReaderFactory.hpp>



xerces_parser::xerces_parser() : parser_(NULL) {}


xerces_parser::~xerces_parser() { 
  if (parser_)
    delete parser_;
}


document *xerces_parser::parse_stdin(){
  StdInInputSource is;
  return parse(is);
}



document *xerces_parser::parse(const char *buff){

  char *membuf_id = "(document on memory)";
  MemBufInputSource membuf_is( reinterpret_cast<const XMLByte*>(buff),
			   strlen(buff),
			   membuf_id,
			   false);
  return parse(membuf_is);
  
}


document *xerces_parser::parse(const std::string& document){

  char *membuf_id = "(document on memory)";
  MemBufInputSource membuf_is( reinterpret_cast<const XMLByte*>(document.c_str()),
			   document.length(),
			   membuf_id,
			   false);
  return parse(membuf_is);
  
}



document *xerces_parser::parse(InputSource &is) {
  
  bool do_namespaces = true;
  bool do_schema = false;
  bool full_checking = false;
  SAX2XMLReader::ValSchemes valschemes = SAX2XMLReader::Val_Auto;

  if (!parser_)
    parser_ = XMLReaderFactory::createXMLReader();
  
  xerces_handler *handler = new xerces_handler();

  SAX2XMLReader* parser = XMLReaderFactory::createXMLReader();
  parser->setFeature(XMLUni::fgSAX2CoreNameSpaces, do_namespaces);
  parser->setFeature(XMLUni::fgSAX2CoreNameSpacePrefixes, do_namespaces);

  parser->setFeature(XMLUni::fgXercesSchema, do_schema);
  parser->setFeature(XMLUni::fgXercesSchemaFullChecking, full_checking);

  if (valschemes == SAX2XMLReader::Val_Auto)  {
      parser->setFeature(XMLUni::fgSAX2CoreValidation, true);
      parser->setFeature(XMLUni::fgXercesDynamic, true);
  }
  if (valschemes == SAX2XMLReader::Val_Never)  {
      parser->setFeature(XMLUni::fgSAX2CoreValidation, false);
  }
  if (valschemes == SAX2XMLReader::Val_Always)  {
      parser->setFeature(XMLUni::fgSAX2CoreValidation, true);
      parser->setFeature(XMLUni::fgXercesDynamic, false);
  }


  parser_->setContentHandler(handler);
  parser_->setErrorHandler(handler);
  
  parser_->parse(is);
  
  document *doc = handler->adopt_document();
  delete handler;
  return doc;
}

#endif
