// -*- c++ -*-
#ifndef AKAXISO_MEMBERARRAY_HANDLER_H__
#define AKAXISO_MEMBERARRAY_HANDLER_H__

#include <akaxiso/parser/handler.h>

namespace akaxiso {

  class memberarray;
  class member_info;
  
  class memberarray_handler : public handler {
  public:
    memberarray_handler(memberarray *ma, const member_info &meminfo, handlers &handlers, const locator *locator);
    virtual ~memberarray_handler(){}
    virtual void query_element(const name &qname, const attributes &attrs, const global_attributes &gattrs);
    virtual void prepare_element(const name &qname, const attributes &attrs, const global_attributes &gattrs);
    virtual void end_element(const name &qname);
    virtual void parse_entity(const std::string &entity);
    virtual bool rollup() const;

    virtual element *get_element();
    virtual void receive_child(element *e);

  private:
    memberarray *ma_;
    const member_info &meminfo_;
    name qname_;
  };

}

#endif

