// -*- c++ -*-
#ifndef AKAXISO_SIMPLETYPE_IMPL_H__
#define AKAXISO_SIMPLETYPE_IMPL_H__

#include <akaxiso/classes/membertypes.h>
#include <akaxiso/classes/builtin.h>
#include <akaxiso/classes/namespaces.h>

namespace akaxiso {


  template<class V>
  class simpletype_member_type_impl : public simpletype_member_type {
  public:
    simpletype_member_type_impl(int offset) : offset_(offset), has_default_(false) {}

    virtual void write_text(const element &element, std::ostream &ostm, const global_attributes &gattrs) const; 
    virtual void read_text(element &element, std::istringstream &istm, const global_attributes &gattrs) const;

    virtual bool is_equal(const element &element1, const element &element2) const;
    virtual void copy(element &dst, const element &src) const;
    virtual void initialize_instance(element &element) const;
    virtual baseclass_id get_baseclass_id() const;

    virtual void set_default_value(const char *defval);
    virtual bool is_default(const element &element) const;

  protected:
    int offset_;
    V default_;
    bool has_default_;
  };


  template<class V>
  void simpletype_member_type_impl<V>::write_text(const element &element, std::ostream &ostm, const global_attributes &gattrs) const {
    const V& v = *get_member_ptr<const V>(element, offset_);
    v.write_text(ostm, gattrs);
  }

  template<class V>
  void simpletype_member_type_impl<V>::read_text(element &element, std::istringstream &istm, const global_attributes &gattrs) const {
    V& v = *get_member_ptr<V>(element, offset_);
    if (!v.read_text(istm, gattrs))
      throw parse_exception(__FILE__, __LINE__, "Failed to parse simpletype");
  }

  template<class V>
  bool simpletype_member_type_impl<V>::is_equal(const element &element1, const element &element2) const {
    const V& v1 = *get_member_ptr<const V>(element1, offset_);
    const V& v2 = *get_member_ptr<const V>(element2, offset_);
    return v1.is_equal_to(v2);
  }

  template<class V>
  void simpletype_member_type_impl<V>::copy(element &dst, const element &src) const{
    V& vdst = *get_member_ptr<V>(dst, offset_);
    const V& vsrc = *get_member_ptr<const V>(src, offset_);
    vsrc.copy_to(vdst);
  }

  template<class V>
  void simpletype_member_type_impl<V>::initialize_instance(element &element) const{
    if (has_default_) {
      V& v = *get_member_ptr<V>(element, offset_);
      default_.copy_to(v);
    }
  }

  template<class V>
  baseclass_id simpletype_member_type_impl<V>::get_baseclass_id() const{
    return simpletype_id;
  }

  template<class V>
  void simpletype_member_type_impl<V>::set_default_value(const char *defval){ 
    std::istringstream istm(defval);
    default_.read_text(istm, static_global_attributes());
    has_default_ = true;
  }

  template<class V>
  bool simpletype_member_type_impl<V>::is_default(const element &element) const{
    if (has_default_) {
      const V& v= *get_member_ptr<const V>(element, offset_);
      return v.is_equal_to(default_);
    }
    return false;
  }

}


#endif
