/* -*- c++ -*- */
#ifndef AKAXISO_MEMBERARRAY_IMPL_H__
#define AKAXISO_MEMBERARRAY_IMPL_H__

#include <akaxiso/classes/memberarray.h>
#include <akaxiso/classes/refiterator.h>

namespace akaxiso {

  template<class V>
  class memberarray_impl : public memberarray {
  public:
    typedef refiterator<container_type::iterator, V> iterator;
    typedef const_refiterator<container_type::const_iterator, container_type::iterator, V> const_iterator;

    iterator begin() { return container_.begin(); }
    iterator end() { return container_.end(); }
    const_iterator begin() const { return container_.begin(); }
    const_iterator end() const { return container_.end(); }

    void push_back(V* e);
    virtual const typeinfo &get_value_typeinfo() const;
    virtual element* create_element() const;
  };

  template<class V>
  void memberarray_impl<V>::push_back(V *e) {
    memberarray::push_back(e);
  }

  template<class V>
  element* memberarray_impl<V>::create_element() const {
    return V::create();
  }

  template<class V>
  const typeinfo &memberarray_impl<V>::get_value_typeinfo() const {
    return reinterpret_cast<V*>(0)->V::get_typeinfo();
  }


  template<class V>
  class memberarray_member_type_impl : public memberarray_member_type {
  public:
    memberarray_member_type_impl(int offset) : memberarray_member_type(offset){}

    virtual bool is_equal(const element &element1, const element &element2) const;
    virtual void copy(element &dst, const element &src) const;
    virtual void initialize_instance(element &element) const;
    virtual baseclass_id get_baseclass_id() const;

    virtual memberarray* get_memberarray(element &e) const;
    virtual const memberarray* get_memberarray(const element &e) const;
  };


  template<class V>
  bool memberarray_member_type_impl<V>::is_equal(const element &element1, const element &element2) const {

    if (&element1.get_typeinfo() != &element2.get_typeinfo())
      throw internal_error();

    const memberarray & ma1 = *get_member_ptr<const memberarray>(element1, offset_);
    const memberarray & ma2 = *get_member_ptr<const memberarray>(element2, offset_);

    if (ma1.size() != ma2.size())
      return false;

    memberarray::const_iterator it1 = ma1.begin();
    memberarray::const_iterator it2 = ma2.begin();
    
    while ((it1 != ma1.end())/* && (it2 != ma2.end()) */) {
      bool res = (*it1)->is_equal_to(*it2);
      if (!res)
	return false;
      ++it1; ++it2;
    }
    return true;
  }

  template<class V>
  void memberarray_member_type_impl<V>::copy(element &dst, const element &src) const {
    if (&dst.get_typeinfo() != &src.get_typeinfo())
      throw invalid_argument();

    memberarray & madst = *get_member_ptr<memberarray>(dst, offset_);
    const memberarray & masrc = *get_member_ptr<const memberarray>(src, offset_);

    madst.clear();
    for (memberarray::const_iterator it = masrc.begin(); it != masrc.end(); ++it) {
      element *replicated = (*it)->replicate_element();
      madst.push_back(replicated);
    }
  }
  
  template<class V>
  void memberarray_member_type_impl<V>::initialize_instance(element &element) const {
  }

  template<class V>
  baseclass_id memberarray_member_type_impl<V>::get_baseclass_id() const {
    return memberarray_id;
  }

  template<class V>
  memberarray* memberarray_member_type_impl<V>::get_memberarray(element &e) const {
    return get_member_ptr<memberarray>(e, offset_);
  }

  template<class V>
  const memberarray* memberarray_member_type_impl<V>::get_memberarray(const element &e) const {
    return get_member_ptr<const memberarray>(e, offset_);
  }


}

#endif
