// -*- c++ -*-
#ifndef AKAXISO_DOCUMENT_IMPL_H__
#define AKAXISO_DOCUMENT_IMPL_H__

#include <akaxiso/classes/document.h>
#include <akaxiso/classes/name.h>




namespace akaxiso {


  template<class T, class E>
  class document_impl : public document {
  public:
    document_impl() {}
    virtual ~document_impl() {}

    virtual const name &get_root_tagname() const { return document_name_;}

    E *get_root() { return static_cast<E*>(element_); }
    const E *get_root() const { return static_cast<E*>(element_); }

    static T *create();
    static document *create_document();
    static void initialize();
    static void uninitialize() {}

    template<class NS> 
    static void define_document(const char *roottag, const NS& ns = NS()) {
      document_name_.set_name(ns.uri(), roottag);
    }
    static void define_document(const char *roottag) {
      document_name_.set_name(roottag);
    }

  private:
    static name document_name_;
  };

  template<class T, class E>
  name document_impl<T, E>::document_name_;

  template<class T, class E>
  void document_impl<T, E>::initialize() { 
    T::initialize_types();
    document_factory::register_document_type(document_name_, &T::create_document);
  }


  template<class T, class E>
  T *document_impl<T, E>::create() {
    T *t = new T;
    t->element_ = E::create();
    return t;
  }

  template<class T, class E>
  document *document_impl<T, E>::create_document() {
    return T::create();
  }



}


#endif
