// -*- c++ -*-
#ifndef AKAXISO_DOCUMENT_H__
#define AKAXISO_DOCUMENT_H__

#include <akaxiso/classes/types.h>
#include <akaxiso/classes/element.h>
#include <akaxiso/classes/name.h>
#include <map>

namespace akaxiso {

  class document {
  protected:
    document() : element_(NULL) {}
  public:
    virtual ~document();
    virtual const name &get_root_tagname() const = 0;
    
    bool empty() const { return element_ == NULL; }
    element *get_root_element() {
      return element_;
    }
    const element *get_root_element() const {
      return element_;
    }

  protected:
    element* element_;
  };


  class document_factory {
  public:
    typedef document* (*document_creator)();

    static void register_document_type(const name &qname, document_creator creator);
    static document *create_named_document(const name &qname);
    static void clear(){
      doctype_map_.clear();
    }
  private:
    typedef std::map<name, document_creator, name_less> doctype_map;
    static doctype_map doctype_map_;
  };

  
}

#endif
