// -*- c++ -*-
#ifndef AKAXISO_CHOICEIMPL_H__
#define AKAXISO_CHOICEIMPL_H__

#include <akaxiso/classes/choice.h>
#include <akaxiso/classes/name.h>
#include <akaxiso/classes/base_impl.h>

namespace akaxiso {
  
  
  template<class T, class I>
  class itemtype_impl : public itemtype {
  public:
    typedef T tagname;
    itemtype_impl() {
      name_.set_name(static_cast<const T*>(this)->get_tagname());
    }
    
    virtual element* create_element() const;
    virtual const name &get_qname() const;
    virtual const typeinfo &get_typeinfo() const;
    virtual itemtype* create() const { return new T; }
  };

  template<class T, class I>
  element *itemtype_impl<T, I>::create_element() const {
    return I::create();
  }

  template<class T, class I>
  const typeinfo &itemtype_impl<T, I>::get_typeinfo() const {
    return reinterpret_cast<I*>(0)->I::get_typeinfo();
  }

  template<class T, class I>
  const name &itemtype_impl<T, I>::get_qname() const {
    return name_;
  }


  template<class T>
  class choice_impl : public choice , public base_impl<T> {
  protected:
    typedef T finalclass;
  public:
    choice_impl() : choice(choice_info_){};

    virtual element *replicate_element() const;
    T* replicate() const;

    static void initialize();
    static void uninitialize();
    static T* create();

    template<class E>
    void get_typesafe_elementlist(E &el, const std::string &tagname) {
      int dummy; dummy = E::this_class_derives_from_the_elementlist_impl;
      name name;
      name.set_name(tagname);
      get_elementlist_impl(name, el);
    }

    template<class E>
    void get_typesafe_elementlist(E &el, const std::string &tagname) const{
      int dummy;
      dummy = E::this_class_derives_from_the_elementlist_impl;
      name name;
      name.set_name(tagname);
      get_elementlist_impl(name, el);
    }

    virtual const typeinfo &get_typeinfo() const;
    virtual const attribute_info &get_attribute_info() const;

    static void define_item(const itemtype &type) {
      T::static_choice_info().register_itemtype(type.create());
    }

    static choice_info &static_choice_info() { return choice_info_; }
    static attribute_info &static_attribute_info() { return attribute_info_; }
  protected:
    static typeinfo &static_typeinfo() { return typeinfo_; }
  private:
    static choice_info choice_info_;
  };

  template<class T>
  choice_info choice_impl<T>::choice_info_;

  template<class T>
  const typeinfo &choice_impl<T>::get_typeinfo() const {
    return typeinfo_;
  }

  template<class T>
  const attribute_info &choice_impl<T>::get_attribute_info() const {
    return attribute_info_;
  }


  template<class T>
  T* choice_impl<T>::create() {
    T* t = new T;
    static_attribute_info().initialize_instance(*t);
    return t;
  }
  template<class T>
  void choice_impl<T>::initialize() {
    choice_info_.clear();
    T::initialize_types();
  }

  template<class T>
  void choice_impl<T>::uninitialize() {
    choice_info_.clear();
  }

  template<class T>
  T* choice_impl<T>::replicate() const {
    T* t = create();
    copy_to(t);
    return t;
  }


  template<class T>
  element *choice_impl<T>::replicate_element() const {
    return replicate();
  }




  template<class T>
  class choice_member_type_impl : public element_member_type {
  public:
    choice_member_type_impl(int offset) : element_member_type(offset){}
    virtual bool is_equal(const element &seq1, const element &seq2) const;
    virtual void copy(element &dst, const element &src) const;
    virtual void initialize_instance(element &seq) const;
    virtual baseclass_id get_baseclass_id() const;
  };

  template<class T>
  bool choice_member_type_impl<T>::is_equal(const element &seq1, const element &seq2) const {
    const T& t1 = *get_member_ptr<const T>(seq1, offset_);
    const T& t2 = *get_member_ptr<const T>(seq2, offset_);
    return t1.is_equal_to(&t2);
  }

  template<class T>
  void choice_member_type_impl<T>::copy(element &dst, const element &src) const {
    T& tdst = *get_member_ptr<T>(dst, offset_);
    const T& tsrc = *get_member_ptr<const T>(src, offset_);
    tsrc.copy_to(&tdst);
  } 

  template<class T>
  void choice_member_type_impl<T>::initialize_instance(element &element) const {
    T& tdst = *get_member_ptr<T>(element, offset_);
    T::static_attribute_info().initialize_instance(tdst);
  }


  template<class T>
  baseclass_id choice_member_type_impl<T>::get_baseclass_id() const {
    return choice_id;
  }


}

#endif
