/* -*- c++ -*- */
#ifndef AKAXISO_ATTRIBUTE_MEMBERTYPE_H__
#define AKAXISO_ATTRIBUTE_MEMBERTYPE_H__

#include <akaxiso/classes/simpletype_impl.h>
#include <akaxiso/classes/builtin.h>

namespace akaxiso {

  enum attribute_use {
    required = 1,
    optional,
  };


  class attribute_member_type : public simpletype_member_type {
  public:
    attribute_member_type(simpletype_member_type *memtype) : memtype_(memtype), use_(optional){}

    void write_text(const element &elm, std::ostream &ostm, const global_attributes &gattrs) const {
      memtype_->write_text(elm, ostm, gattrs);
    }
    void read_text(element &elm, std::istringstream &istm, const global_attributes &gattrs) const {
      memtype_->read_text(elm, istm, gattrs);
    }
    bool is_equal(const element &element1, const element &element2) const {
      return memtype_->is_equal(element1, element2);
    }

    void copy(element &dst, const element &src) const {
      memtype_->copy(dst, src);
    }

    void initialize_instance(element &element) const {
      memtype_->initialize_instance(element);
    }

    baseclass_id get_baseclass_id() const {
      return memtype_->get_baseclass_id();
    }

    void set_default_value(const char *defval) {
      memtype_->set_default_value(defval);
    }

    bool is_default(const element &element) const {
      return memtype_->is_default(element);
    }

    const attribute_use get_use() const;
    bool  should_write(const element &elm) const;
    void  set_use(const attribute_use use);

  protected:
    simpletype_member_type *memtype_;
    attribute_use use_;    
  };
  
}


#endif
