/* -*- c++ -*- */
#ifndef TEST_RESULT_H__
#define TEST_RESULT_H__

#include "AnnotatedTSSchema.h"

enum outcome {
  ok = 0,
  file_not_found,
  schema_not_wellformed,
  schema_not_deserialized,
  schema_not_processed,
  source_generation_failed,
  succeeded_but_invalid
};

enum validity {
  valid = 0,
  invalid,
  notKnown
};

typedef std::pair<outcome, std::string> error_message;
typedef std::vector<error_message> error_messages;

class test_result {
  const ts::testSet *testSet_;
  std::string dirpath_;
  const ts::testGroup *testGroup_;
  const ts::schemaTest *schemaTest_;
  const ts::ref *ref_;

  outcome outcome_;

  error_messages errors_;


  validity get_validity() const;
public:
  test_result(const ts::testSet &testSet, const std::string &dirpath,
	      const ts::testGroup &testGroup, const ts::schemaTest &schemaTest,
	      const ts::ref &ref);
  test_result();


  bool expected_to_pass() const;
  bool passed() const;
  bool failed_but_valid() const;
  bool succeeded_but_invalid() const;


  std::string get_test_id() const;
  std::string get_test_dir_path() const;
  std::string get_schema_path() const;

  void add_error(outcome oc, const std::string &message);
  void write_error(outcome oc, std::ostream &ostm) const;

  outcome get_outcome() const {
    return outcome_;
  }
};


typedef std::vector<test_result> test_results;

#endif
