#include "test_result.h"
#include <assert.h>
#include <iostream>

validity test_result::get_validity() const {
  ts::expected *exp = schemaTest_->expected_.get();
  if (exp == 0)
    return notKnown;
  if (exp->validity_ == "valid")
    return valid;
  else if (exp->validity_ == "invalid")
    return invalid;
  else if (exp->validity_ == "notKnown")
    return notKnown;
  assert(!"Must not reach here.");
  return notKnown;
}

test_result::test_result(const ts::testSet &testSet, const std::string &dirpath,
			 const ts::testGroup &testGroup, const ts::schemaTest &schemaTest,
			 const ts::ref &ref)
  : testSet_(&testSet), dirpath_(dirpath), 
    testGroup_(&testGroup), schemaTest_(&schemaTest),
    ref_(&ref),
    outcome_(ok) {
}

test_result::test_result() 
  : testSet_(0), 
    testGroup_(0), schemaTest_(0),
    ref_(0),
    outcome_(ok) {
}


bool test_result::expected_to_pass() const {
  return  get_validity() == valid;
}

bool test_result::passed() const {
  return outcome_ == ok;
}

bool test_result::failed_but_valid() const {
  return (!passed()) && expected_to_pass();
}

bool test_result::succeeded_but_invalid() const {
  return passed() && (!expected_to_pass());
}


std::string test_result::get_test_id() const {
  return testSet_->name_ + ':' + testGroup_->name_ + ':' + schemaTest_->name_;
}

std::string test_result::get_test_dir_path() const {
  return testSet_->name_ + '/' + testGroup_->name_ + '/' + schemaTest_->name_;
}

std::string test_result::get_schema_path() const {
  return dirpath_ + '/' + ref_->xlink_href_;
}

void test_result::add_error(outcome oc, const std::string &message) {
  outcome_ = oc;
  errors_.push_back(error_message(oc, message));
}

void test_result::write_error(outcome oc, std::ostream &ostm) const {
  std::string message;
  for (error_messages::const_iterator mesit = errors_.begin();
       mesit != errors_.end(); ++mesit) {
    if (mesit->first == oc) {
      ostm << ref_->xlink_href_ << ": " << mesit->second << std::endl;
    }
  }
}
