#include <unistd.h>
#include "test_executor.h"

#include <akaxiso2/akaxiso2.h>
#include <osixaka2/osixaka2.h>
#include <iostream>

#include "AnnotatedTSSchema.h"


int main(int argc, char *argv[]) {

  aka::initialize();
  instantiate_xiso();
  osx::osixaka2::initialize();
  
  int c;
  while ((c = getopt(argc, argv, "")) != -1) {
    switch (c) {
    case '?':
    default:
      return 1;
    }
  }

  test_executor ex;

  for (int index = optind; index < argc; ++index) {
    aka::document doc;
    std::string filepath = argv[index];
    try {
      doc = aka::deserialize_file(filepath);
    }    
    catch (const std::exception &e) {
      std::cerr << argv[index]
		<< ": " << e.what() << std::endl;
    }
    catch ( ... ) {
      std::cerr << argv[index] << 
	": Unhandled exception caught.  Exit now." << std::endl;
    }

    if (aka::document_of(doc, "ts:testSuite")) {
      ex.set_testSuite(*aka::root_cast<ts::testSuite>(doc), filepath);
    }
    else if (aka::document_of(doc, "ts:testSet")) {
      ex.set_testSet(*aka::root_cast<ts::testSet>(doc), filepath);
    }
    else {
      std::cerr << argv[index] <<
	": Unknown document." << std::endl;
    }
  }

  {
    std::ostringstream ostm;
    std::clog << "Checking schema files...";
    ex.check_files();
    std::clog << "done." << std::endl;
    ex.write_error(file_not_found, ostm);
    if (!ostm.str().empty()) {
      std::cerr << ostm.str()
		<< std::endl;
    }
  }
  
  {
    std::ostringstream ostm;
    std::clog << "Checking schema wellformedness...";
    ex.check_schema_wellformedness();
    std::clog << "done." << std::endl;
    ex.write_error(schema_not_wellformed, ostm);
    if (!ostm.str().empty()) {
      std::cerr << ostm.str()
		<< std::endl;
    }
  }
  
  {
    std::ostringstream ostm;
    std::clog << "Validating osixaka2 schema deserializer...";
    ex.validate_schema_deserialization(); 
    std::clog << "done." << std::endl;
    ex.write_error(schema_not_deserialized, ostm);
    if (!ostm.str().empty()) {
      std::cerr << ostm.str()
		<< std::endl;
    }
  }
  
  {
    std::ostringstream ostm;
    std::clog << "Validating osixaka2 source generator...";
    ex.validate_source_generation();
    std::clog << "done." << std::endl;
    ex.write_error(schema_not_processed, ostm);
    ex.write_error(source_generation_failed, ostm);
    if (!ostm.str().empty()) {
      std::cerr << ostm.str()
		<< std::endl;
    }
  }

  {  
    std::ostringstream ostm;
    ex.write_invalid_passes(ostm);
    if (!ostm.str().empty()) {
      std::cerr << ostm.str()
		<< std::endl;
    }
  }  

  std::cerr << "Num tests: total " << ex.get_num_tests() << " to check " << ex.get_num_tests(succeeded_but_invalid) << std::endl;

  aka::uninitialize();
}
