#include "AnnotatedTSSchema_xiso.h"

#include <akaxiso2/akaxiso2.h>


namespace xlink {


}



namespace xml {


}



namespace ts {

  void ref_leaf::model() {
    /** XML-Schema type name. */
    xmltype("ts:ref");
    /** attribute member definition. */
    attribute("xlink:type", &::ts::ref::xlink_type_, xs::string_leaf()).set_default("locator");
    attribute("xlink:href", &::ts::ref::xlink_href_, xs::anyURI_leaf());
    any_attribute(&::ts::ref::attributes_, "##other:TestSuite");
  }

  void statusEntry_leaf::model() {
    /** XML-Schema type name. */
    xmltype("ts:statusEntry");
    /** attribute member definition. */
    attribute("status", &::ts::statusEntry::status_, xs::token_leaf()).required(true);
    attribute("date", &::ts::statusEntry::date_, xs::date_leaf()).required(true);
    any_attribute(&::ts::statusEntry::attributes_, "##other:TestSuite");
  }

  void appinfo_leaf::model() {
    /** XML-Schema type name. */
    xmltype("ts:appinfo");
    /** element member definitions */
    any("&any", &::ts::appinfo::any_, 0, aka::unbounded, "##any");
    /** attribute member definition. */
    attribute("source", &::ts::appinfo::source_, xs::anyURI_leaf());
    any_attribute(&::ts::appinfo::attributes_, "##other:TestSuite");
  }

  void documentation_leaf::model() {
    /** XML-Schema type name. */
    xmltype("ts:documentation");
    /** element member definitions */
    any("&any", &::ts::documentation::any_, 0, aka::unbounded, "##any");
    /** attribute member definition. */
    attribute("source", &::ts::documentation::source_, xs::anyURI_leaf());
    attribute("xml:lang", &::ts::documentation::xml_lang_, xs::language_leaf());
    any_attribute(&::ts::documentation::attributes_, "##other:TestSuite");
  }

  void annotation_choice_leaf::model() {
    /** XML-Schema type name. */
    xmltype("ts:annotation_choice");
    /** occurrence used when choice is a root element. */
    occurrence(0, aka::unbounded);
    /** element member definitions */
    item("ts:appinfo", ::ts::appinfo_leaf());
    item("ts:documentation", ::ts::documentation_leaf());
  }

  void annotation_leaf::model() {
    /** XML-Schema type name. */
    xmltype("ts:annotation");
    /** element member definitions */
    member("&c0", &::ts::annotation::c0_, ::ts::annotation_choice_leaf(), 0, aka::unbounded);
    /** attribute member definition. */
    any_attribute(&::ts::annotation::attributes_, "##other:TestSuite");
  }

  void expected_leaf::model() {
    /** XML-Schema type name. */
    xmltype("ts:expected");
    /** attribute member definition. */
    attribute("validity", &::ts::expected::validity_, xs::token_leaf()).required(true);
    any_attribute(&::ts::expected::attributes_, "##other:TestSuite");
  }

  void instanceTest_leaf::model() {
    /** XML-Schema type name. */
    xmltype("ts:instanceTest");
    /** element member definitions */
    member("ts:instanceDocument", &::ts::instanceTest::instanceDocument_, ::ts::ref_leaf());
    ptrmember("ts:expected", &::ts::instanceTest::expected_, ::ts::expected_leaf());
    ptrmember("ts:current", &::ts::instanceTest::current_, ::ts::statusEntry_leaf());
    member("ts:prior", &::ts::instanceTest::prior_, ::ts::statusEntry_array_leaf(), 0, aka::unbounded);
    /** attribute member definition. */
    attribute("name", &::ts::instanceTest::name_, xs::normalizedString_leaf()).required(true);
    any_attribute(&::ts::instanceTest::attributes_, "##other:TestSuite");
  }

  void schemaTest_leaf::model() {
    /** XML-Schema type name. */
    xmltype("ts:schemaTest");
    /** element member definitions */
    member("ts:schemaDocument", &::ts::schemaTest::schemaDocument_, ::ts::ref_array_leaf(), 1, aka::unbounded);
    ptrmember("ts:expected", &::ts::schemaTest::expected_, ::ts::expected_leaf());
    ptrmember("ts:current", &::ts::schemaTest::current_, ::ts::statusEntry_leaf());
    member("ts:prior", &::ts::schemaTest::prior_, ::ts::statusEntry_array_leaf(), 0, aka::unbounded);
    /** attribute member definition. */
    attribute("name", &::ts::schemaTest::name_, xs::normalizedString_leaf()).required(true);
    any_attribute(&::ts::schemaTest::attributes_, "##other:TestSuite");
  }

  void testGroup_leaf::model() {
    /** XML-Schema type name. */
    xmltype("ts:testGroup");
    /** element member definitions */
    ptrmember("ts:annotation", &::ts::testGroup::annotation_, ::ts::annotation_leaf());
    member("ts:documentationReference", &::ts::testGroup::documentationReference_, ::ts::ref_array_leaf(), 0, aka::unbounded);
    ptrmember("ts:schemaTest", &::ts::testGroup::schemaTest_, ::ts::schemaTest_leaf());
    member("ts:instanceTest", &::ts::testGroup::instanceTest_, ::ts::instanceTest_array_leaf(), 0, aka::unbounded);
    /** attribute member definition. */
    attribute("name", &::ts::testGroup::name_, xs::normalizedString_leaf()).required(true);
    any_attribute(&::ts::testGroup::attributes_, "##other:TestSuite");
  }

  void testResult_leaf::model() {
    /** XML-Schema type name. */
    xmltype("ts:testResult");
    /** element member definitions */
    ptrmember("ts:annotation", &::ts::testResult::annotation_, ::ts::annotation_leaf());
    /** attribute member definition. */
    attribute("validity", &::ts::testResult::validity_, xs::token_leaf()).required(true);
    attribute("set", &::ts::testResult::set_, xs::Name_leaf()).required(true);
    attribute("group", &::ts::testResult::group_, xs::Name_leaf()).required(true);
    attribute("test", &::ts::testResult::test_, xs::Name_leaf()).required(true);
    attribute("normalizedLoad", &::ts::testResult::normalizedLoad_, xs::decimal_leaf());
    any_attribute(&::ts::testResult::attributes_, "##other:TestSuite");
  }

  void testSet_leaf::model() {
    /** XML-Schema type name. */
    xmltype("ts:testSet");
    /** element member definitions */
    ptrmember("ts:annotation", &::ts::testSet::annotation_, ::ts::annotation_leaf());
    member("ts:testGroup", &::ts::testSet::testGroup_, ::ts::testGroup_array_leaf(), 0, aka::unbounded);
    /** attribute member definition. */
    attribute("contributor", &::ts::testSet::contributor_, xs::string_leaf()).required(true);
    attribute("name", &::ts::testSet::name_, xs::normalizedString_leaf()).required(true);
    any_attribute(&::ts::testSet::attributes_, "##other:TestSuite");
  }

  void testSuite_leaf::model() {
    /** XML-Schema type name. */
    xmltype("ts:testSuite");
    /** element member definitions */
    ptrmember("ts:annotation", &::ts::testSuite::annotation_, ::ts::annotation_leaf());
    member("ts:testSetRef", &::ts::testSuite::testSetRef_, ::ts::ref_array_leaf(), 0, aka::unbounded);
    /** attribute member definition. */
    attribute("name", &::ts::testSuite::name_, xs::normalizedString_leaf()).required(true);
    attribute("releaseDate", &::ts::testSuite::releaseDate_, xs::date_leaf()).required(true);
    attribute("schemaVersion", &::ts::testSuite::schemaVersion_, xs::string_leaf()).required(true);
    any_attribute(&::ts::testSuite::attributes_, "##other:TestSuite");
  }

  void testSuiteResults_leaf::model() {
    /** XML-Schema type name. */
    xmltype("ts:testSuiteResults");
    /** element member definitions */
    ptrmember("ts:annotation", &::ts::testSuiteResults::annotation_, ::ts::annotation_leaf());
    member("ts:testResult", &::ts::testSuiteResults::testResult_, ::ts::testResult_array_leaf(), 0, aka::unbounded);
    /** attribute member definition. */
    attribute("suite", &::ts::testSuiteResults::suite_, xs::Name_leaf()).required(true);
    attribute("processor", &::ts::testSuiteResults::processor_, xs::string_leaf()).required(true);
    attribute("submitDate", &::ts::testSuiteResults::submitDate_, xs::date_leaf()).required(true);
    attribute("publicationPermission", &::ts::testSuiteResults::publicationPermission_, xs::string_leaf());
    any_attribute(&::ts::testSuiteResults::attributes_, "##other:TestSuite");
  }


}

void instantiate_xiso() {
  aka::xmlns("xlink", "http://www.w3.org/1999/xlink");
  aka::xmlns("ts", "TestSuite");
  aka::doctype("ts:annotation", ::ts::annotation_leaf());
  aka::doctype("ts:appinfo", ::ts::appinfo_leaf());
  aka::doctype("ts:current", ::ts::statusEntry_leaf());
  aka::doctype("ts:documentation", ::ts::documentation_leaf());
  aka::doctype("ts:documentationReference", ::ts::ref_leaf());
  aka::doctype("ts:expected", ::ts::expected_leaf());
  aka::doctype("ts:instanceDocument", ::ts::ref_leaf());
  aka::doctype("ts:instanceTest", ::ts::instanceTest_leaf());
  aka::doctype("ts:prior", ::ts::statusEntry_leaf());
  aka::doctype("ts:schemaDocument", ::ts::ref_leaf());
  aka::doctype("ts:schemaTest", ::ts::schemaTest_leaf());
  aka::doctype("ts:testGroup", ::ts::testGroup_leaf());
  aka::doctype("ts:testResult", ::ts::testResult_leaf());
  aka::doctype("ts:testSet", ::ts::testSet_leaf());
  aka::doctype("ts:testSetRef", ::ts::ref_leaf());
  aka::doctype("ts:testSuite", ::ts::testSuite_leaf());
  aka::doctype("ts:testSuiteResults", ::ts::testSuiteResults_leaf());
}

void serialize(const ::ts::annotation& root, std::ostream &ostm) {
  aka::xml_serializer ser;
  ser.serialize(root, "ts:annotation", ostm);
}

void serialize(const ::ts::appinfo& root, std::ostream &ostm) {
  aka::xml_serializer ser;
  ser.serialize(root, "ts:appinfo", ostm);
}

void serialize(const ::ts::documentation& root, std::ostream &ostm) {
  aka::xml_serializer ser;
  ser.serialize(root, "ts:documentation", ostm);
}

void serialize(const ::ts::expected& root, std::ostream &ostm) {
  aka::xml_serializer ser;
  ser.serialize(root, "ts:expected", ostm);
}

void serialize(const ::ts::instanceTest& root, std::ostream &ostm) {
  aka::xml_serializer ser;
  ser.serialize(root, "ts:instanceTest", ostm);
}

void serialize(const ::ts::ref& root, const std::string &tagname, std::ostream &ostm) {
  aka::xml_serializer ser;
  ser.serialize(root, tagname, ostm);
}

void serialize(const ::ts::schemaTest& root, std::ostream &ostm) {
  aka::xml_serializer ser;
  ser.serialize(root, "ts:schemaTest", ostm);
}

void serialize(const ::ts::statusEntry& root, const std::string &tagname, std::ostream &ostm) {
  aka::xml_serializer ser;
  ser.serialize(root, tagname, ostm);
}

void serialize(const ::ts::testGroup& root, std::ostream &ostm) {
  aka::xml_serializer ser;
  ser.serialize(root, "ts:testGroup", ostm);
}

void serialize(const ::ts::testResult& root, std::ostream &ostm) {
  aka::xml_serializer ser;
  ser.serialize(root, "ts:testResult", ostm);
}

void serialize(const ::ts::testSet& root, std::ostream &ostm) {
  aka::xml_serializer ser;
  ser.serialize(root, "ts:testSet", ostm);
}

void serialize(const ::ts::testSuite& root, std::ostream &ostm) {
  aka::xml_serializer ser;
  ser.serialize(root, "ts:testSuite", ostm);
}

void serialize(const ::ts::testSuiteResults& root, std::ostream &ostm) {
  aka::xml_serializer ser;
  ser.serialize(root, "ts:testSuiteResults", ostm);
}

