/* -*- c++ -*- */
#ifndef AnnotatedTSSchema_h__
#define AnnotatedTSSchema_h__


#include <akaxiso2/builtin/builtin.h>
#include <akaxiso2/builtin/schema_builtin.h>


namespace xlink {

  /** simpleType definitions */

  typedef std::string actuateEnum;

  typedef std::list< std::string> actuateEnum_array;

  typedef std::string showEnum;

  typedef std::list< std::string> showEnum_array;

  typedef std::string typeEnum;

  typedef std::list< std::string> typeEnum_array;


}



namespace xml {

  /** simpleType definitions */

  typedef ::xs::NCName space;

  typedef std::list< ::xml::space> space_array;


}



namespace ts {

  /** simpleType definitions */

  typedef ::xs::token status;

  typedef std::list< ::ts::status> status_array;

  typedef std::string testSuiteResults_publicationPermission;

  typedef std::list< std::string> testSuiteResults_publicationPermission_array;

  typedef ::xs::token validityOutcome;

  typedef std::list< ::ts::validityOutcome> validityOutcome_array;

  /** complexType definitions */

  struct ref {
    /** attributes */
    std::string xlink_type_;
    ::xs::anyURI xlink_href_;
    aka::wc_attributes attributes_;
  };

  typedef std::list< ::ts::ref> ref_array;

  struct statusEntry {
    /** attributes */
    ::ts::status status_;
    ::xs::date date_;
    aka::wc_attributes attributes_;
  };

  typedef std::list< ::ts::statusEntry> statusEntry_array;

  struct appinfo {
    /** members */
    ::aka2::any_array any_;
    /** attributes */
    ::xs::anyURI source_;
    aka::wc_attributes attributes_;
  };

  struct documentation {
    /** members */
    ::aka2::any_array any_;
    /** attributes */
    ::xs::anyURI source_;
    ::xs::language xml_lang_;
    aka::wc_attributes attributes_;
  };

  typedef std::list<aka::item> annotation_choice;

  struct annotation {
    /** members */
    ::ts::annotation_choice c0_;
    /** attributes */
    aka::wc_attributes attributes_;
  };

  struct expected {
    /** attributes */
    ::ts::validityOutcome validity_;
    aka::wc_attributes attributes_;
  };

  struct instanceTest {
    /** members */
    ::ts::ref instanceDocument_;
    aka::deep_ptr< ::ts::expected> expected_;
    aka::deep_ptr< ::ts::statusEntry> current_;
    ::ts::statusEntry_array prior_;
    /** attributes */
    ::xs::normalizedString name_;
    aka::wc_attributes attributes_;
  };

  struct schemaTest {
    /** members */
    ::ts::ref_array schemaDocument_;
    aka::deep_ptr< ::ts::expected> expected_;
    aka::deep_ptr< ::ts::statusEntry> current_;
    ::ts::statusEntry_array prior_;
    /** attributes */
    ::xs::normalizedString name_;
    aka::wc_attributes attributes_;
  };

  typedef std::list< ::ts::instanceTest> instanceTest_array;

  struct testGroup {
    /** members */
    aka::deep_ptr< ::ts::annotation> annotation_;
    ::ts::ref_array documentationReference_;
    aka::deep_ptr< ::ts::schemaTest> schemaTest_;
    ::ts::instanceTest_array instanceTest_;
    /** attributes */
    ::xs::normalizedString name_;
    aka::wc_attributes attributes_;
  };

  struct testResult {
    /** members */
    aka::deep_ptr< ::ts::annotation> annotation_;
    /** attributes */
    ::ts::validityOutcome validity_;
    ::xs::Name set_;
    ::xs::Name group_;
    ::xs::Name test_;
    ::xs::decimal normalizedLoad_;
    aka::wc_attributes attributes_;
  };

  typedef std::list< ::ts::testGroup> testGroup_array;

  struct testSet {
    /** members */
    aka::deep_ptr< ::ts::annotation> annotation_;
    ::ts::testGroup_array testGroup_;
    /** attributes */
    std::string contributor_;
    ::xs::normalizedString name_;
    aka::wc_attributes attributes_;
  };

  struct testSuite {
    /** members */
    aka::deep_ptr< ::ts::annotation> annotation_;
    ::ts::ref_array testSetRef_;
    /** attributes */
    ::xs::normalizedString name_;
    ::xs::date releaseDate_;
    std::string schemaVersion_;
    aka::wc_attributes attributes_;
  };

  typedef std::list< ::ts::testResult> testResult_array;

  struct testSuiteResults {
    /** members */
    aka::deep_ptr< ::ts::annotation> annotation_;
    ::ts::testResult_array testResult_;
    /** attributes */
    ::xs::Name suite_;
    std::string processor_;
    ::xs::date submitDate_;
    std::string publicationPermission_;
    aka::wc_attributes attributes_;
  };


}

void instantiate_xiso();

/** serialization of "ts:annotation". */
void serialize(const ::ts::annotation &root, std::ostream &ostm);
/** serialization of "ts:appinfo". */
void serialize(const ::ts::appinfo &root, std::ostream &ostm);
/** serialization of "ts:documentation". */
void serialize(const ::ts::documentation &root, std::ostream &ostm);
/** serialization of "ts:expected". */
void serialize(const ::ts::expected &root, std::ostream &ostm);
/** serialization of "ts:instanceTest". */
void serialize(const ::ts::instanceTest &root, std::ostream &ostm);
/** serialization of "ts:documentationReference"(::ts::ref), "ts:instanceDocument"(::ts::ref), "ts:schemaDocument"(::ts::ref), "ts:testSetRef"(::ts::ref). */
void serialize(const ::ts::ref& root, const std::string &tagname, std::ostream &ostm);
/** serialization of "ts:schemaTest". */
void serialize(const ::ts::schemaTest &root, std::ostream &ostm);
/** serialization of "ts:current"(::ts::statusEntry), "ts:prior"(::ts::statusEntry). */
void serialize(const ::ts::statusEntry& root, const std::string &tagname, std::ostream &ostm);
/** serialization of "ts:testGroup". */
void serialize(const ::ts::testGroup &root, std::ostream &ostm);
/** serialization of "ts:testResult". */
void serialize(const ::ts::testResult &root, std::ostream &ostm);
/** serialization of "ts:testSet". */
void serialize(const ::ts::testSet &root, std::ostream &ostm);
/** serialization of "ts:testSuite". */
void serialize(const ::ts::testSuite &root, std::ostream &ostm);
/** serialization of "ts:testSuiteResults". */
void serialize(const ::ts::testSuiteResults &root, std::ostream &ostm);
#endif // #ifndef AnnotatedTSSchema_h__
