/* -*- c++ -*- */
#ifndef OSIXAKA2_SIMPLE_MAP_H__
#define OSIXAKA2_SIMPLE_MAP_H__

#include <akaxiso2/configuration.h>
#include <akaxiso2/util/string_funcs.h>
#include <osixaka2/platform.h>
#include <osixaka2/exception.h>

namespace osx {


  struct simple_map {
    virtual ~simple_map(){}
    virtual void erase(const aka::qname &name) = 0;
    virtual void clear() = 0;
    virtual bool exists(const aka::qname &name) const = 0;
  };


  template<class T>
  struct simple_map_T {
    virtual ~simple_map_T(){}

    typedef std::map<aka::qname, T, aka::qname_less> map_type;
    typedef TYPENAME map_type::iterator iterator;
    typedef TYPENAME map_type::const_iterator const_iterator;
  
    map_type map_;
  
    T* insert(const aka::qname &name, const T& t);
    T* get(const aka::qname &name);
    const T* get(const aka::qname &name) const;
    bool exists(const aka::qname &name) const;
    bool exists(const T* t) const;
    void clear();
    bool empty() const { return map_.empty(); }
  
    iterator begin() { return map_.begin(); }
    iterator end() { return map_.end(); }
    const_iterator begin() const { return map_.begin(); }
    const_iterator end() const { return map_.end(); }
  
    virtual void erase(const aka::qname &name);
  };

  template<class T>
  T* simple_map_T<T>::insert(const aka::qname &name, const T& t) {
    //assert(aka::qname("xs:anyType") != name);
    std::pair<TYPENAME map_type::iterator, bool> res =
      map_.insert(OSX_TYPENAME map_type::value_type(name, t));
    if (!res.second) {
      raise_name_error("type", name, "already registered.",
		       __FILE__, __LINE__);
    }
    return &res.first->second;
  }

  template<class T>
  void simple_map_T<T>::erase(const aka::qname &name) {
    TYPENAME map_type::iterator it = map_.find(name);
    // type must be found.
    assert(it != map_.end());
    map_.erase(it);
  }

  template<class T>
  T* simple_map_T<T>::get(const aka::qname &name) {
    TYPENAME map_type::iterator it = map_.find(name);
    if (it != map_.end())
      return &it->second;
    return 0;
  }

  template<class T>
  const T* simple_map_T<T>::get(const aka::qname &name) const {
    TYPENAME map_type::const_iterator it = map_.find(name);
    if (it != map_.end())
      return &it->second;
    return 0;
  }

  template<class T>
  bool simple_map_T<T>::exists(const aka::qname &name) const {
    TYPENAME map_type::const_iterator it = map_.find(name);
    return it != map_.end();
  }

  template<class T>
  bool simple_map_T<T>::exists(const T* t) const {
    TYPENAME map_type::const_iterator it = map_.find(t->get_name());
    if (it == map_.end())
      return false;
    return t == &it->second;
  }

  template<class T>
  void simple_map_T<T>::clear() {
    map_.clear();
  }

}

#endif /* SIMPLE_MAP_H__ */
