/* -*- c++ -*- */
#ifndef serializer_h__
#define serializer_h__


#include <osixaka2/xml.h>
#include <osixaka2/osx.h>
#include <osixaka2/XMLSchema.h>
void osx_instantiate_xiso();

/** serialization of "osx:namespace". */
void serialize(const ::osx::_namespace &root, std::ostream &ostm);
/** serialization of "osx:include"(::osx::include), "osx:ximpl_include"(::osx::include), "osx:xiso_include"(::osx::include). */
void serialize(const ::osx::include& root, const std::string &tagname, std::ostream &ostm);
/** serialization of "osx:preference". */
void serialize(const ::osx::preference &root, std::ostream &ostm);
/** serialization of "xs:union". */
void serialize(const ::xs::_union &root, std::ostream &ostm);
/** serialization of "xs:all". */
void serialize(const ::xs::all &root, std::ostream &ostm);
/** serialization of "xs:annotation". */
void serialize(const ::xs::annotation &root, std::ostream &ostm);
/** serialization of "xs:any". */
void serialize(const ::xs::any &root, std::ostream &ostm);
/** serialization of "xs:appinfo". */
void serialize(const ::xs::appinfo &root, std::ostream &ostm);
/** serialization of "xs:complexContent". */
void serialize(const ::xs::complexContent &root, std::ostream &ostm);
/** serialization of "xs:documentation". */
void serialize(const ::xs::documentation &root, std::ostream &ostm);
/** serialization of "xs:choice"(::xs::explicitGroup), "xs:sequence"(::xs::explicitGroup). */
void serialize(const ::xs::explicitGroup& root, const std::string &tagname, std::ostream &ostm);
/** serialization of "xs:maxExclusive"(::xs::facet), "xs:maxInclusive"(::xs::facet), "xs:minExclusive"(::xs::facet), "xs:minInclusive"(::xs::facet). */
void serialize(const ::xs::facet& root, const std::string &tagname, std::ostream &ostm);
/** serialization of "xs:field". */
void serialize(const ::xs::field &root, std::ostream &ostm);
/** serialization of "xs:import". */
void serialize(const ::xs::import &root, std::ostream &ostm);
/** serialization of "xs:include". */
void serialize(const ::xs::include &root, std::ostream &ostm);
/** serialization of "xs:key"(::xs::keybase), "xs:unique"(::xs::keybase). */
void serialize(const ::xs::keybase& root, const std::string &tagname, std::ostream &ostm);
/** serialization of "xs:keyref". */
void serialize(const ::xs::keyref &root, std::ostream &ostm);
/** serialization of "xs:list". */
void serialize(const ::xs::list &root, std::ostream &ostm);
/** serialization of "xs:attributeGroup". */
void serialize(const ::xs::namedAttributeGroup &root, std::ostream &ostm);
/** serialization of "xs:group". */
void serialize(const ::xs::namedGroup &root, std::ostream &ostm);
/** serialization of "xs:enumeration". */
void serialize(const ::xs::noFixedFacet &root, std::ostream &ostm);
/** serialization of "xs:notation". */
void serialize(const ::xs::notation &root, std::ostream &ostm);
/** serialization of "xs:fractionDigits"(::xs::numFacet), "xs:length"(::xs::numFacet), "xs:maxLength"(::xs::numFacet), "xs:minLength"(::xs::numFacet). */
void serialize(const ::xs::numFacet& root, const std::string &tagname, std::ostream &ostm);
/** serialization of "xs:pattern". */
void serialize(const ::xs::pattern &root, std::ostream &ostm);
/** serialization of "xs:redefine". */
void serialize(const ::xs::redefine &root, std::ostream &ostm);
/** serialization of "xs:restriction". */
void serialize(const ::xs::restriction &root, std::ostream &ostm);
/** serialization of "xs:schema". */
void serialize(const ::xs::schema &root, std::ostream &ostm);
/** serialization of "xs:selector". */
void serialize(const ::xs::selector &root, std::ostream &ostm);
/** serialization of "xs:simpleContent". */
void serialize(const ::xs::simpleContent &root, std::ostream &ostm);
/** serialization of "xs:attribute". */
void serialize(const ::xs::topLevelAttribute &root, std::ostream &ostm);
/** serialization of "xs:complexType". */
void serialize(const ::xs::topLevelComplexType &root, std::ostream &ostm);
/** serialization of "xs:element". */
void serialize(const ::xs::topLevelElement &root, std::ostream &ostm);
/** serialization of "xs:simpleType". */
void serialize(const ::xs::topLevelSimpleType &root, std::ostream &ostm);
/** serialization of "xs:totalDigits". */
void serialize(const ::xs::totalDigits &root, std::ostream &ostm);
/** serialization of "xs:whiteSpace". */
void serialize(const ::xs::whiteSpace &root, std::ostream &ostm);
/** serialization of "xs:anyAttribute". */
void serialize(const ::xs::wildcard &root, std::ostream &ostm);

#endif // #ifndef serializer_h__
