/* -*- c++ -*- */
#ifndef XML_SCHEMA_ST_XISO_H__
#define XML_SCHEMA_ST_XISO_H__

#include <osixaka2/schema_st.h>

namespace xs {

  struct allNNI_leaf : aka::simpletype<allNNI, allNNI_leaf> {
    static void read_text(void *elm, const std::string &entity, 
			  aka::entity_complements &ecomp);
    static void write_text(const void *elm, std::ostream &ostm,
			   aka::entity_complements &ecomp);
    static bool equals(const void *lhs, const void *rhs) {
      return *static_cast<const allNNI*>(lhs) == *static_cast<const allNNI*>(rhs);
    }
  };

  struct attribute_use_leaf : aka::simpletype<attribute_use, attribute_use_leaf> {
    static void read_unicode_text(void *elm, const aka::pstring &entity, 
				  aka::entity_complements &ecomp);
    static void write_text(const void *elm, std::ostream &ostm,
			   aka::entity_complements &ecomp);
  };


  struct blockSet_leaf : aka::simpletype<blockSet, blockSet_leaf> {
    static void read_unicode_text(void *elm, const aka::pstring &entity, 
			  aka::entity_complements &ecomp);
    static void write_text(const void *elm, std::ostream &ostm,
			   aka::entity_complements &ecomp);
  };

  struct all_minOccurs_leaf : aka::simpletype<all_minOccurs, all_minOccurs_leaf> {
    static void read_unicode_text(void *elm, const aka::pstring &entity, 
			  aka::entity_complements &ecomp);
    static void write_text(const void *elm, std::ostream &ostm,
			   aka::entity_complements &ecomp);
  };


  struct all_maxOccurs_leaf : aka::simpletype<all_maxOccurs, all_maxOccurs_leaf> {
    static void read_unicode_text(void *elm, const aka::pstring &entity, 
			  aka::entity_complements &ecomp);
    static void write_text(const void *elm, std::ostream &ostm,
			   aka::entity_complements &ecomp);
  };


  struct namespaceList_leaf : aka::simpletype<namespaceList, namespaceList_leaf> {
    static void read_unicode_text(void *elm, const aka::pstring &entity, 
			  aka::entity_complements &ecomp);
    static void write_text(const void *elm, std::ostream &ostm,
			   aka::entity_complements &ecomp);
  };

  
  struct formChoice_leaf : aka::simpletype<formChoice, formChoice_leaf> {
    static void read_unicode_text(void *elm, const aka::pstring &entity, 
			  aka::entity_complements &ecomp);
    static void write_text(const void *elm, std::ostream &ostm,
			   aka::entity_complements &ecomp);
  };

  struct derivationSet_leaf : aka::simpletype<derivationSet, derivationSet_leaf> {
    static void read_unicode_text(void *elm, const aka::pstring &entity, 
			  aka::entity_complements &ecomp);
    static void write_text(const void *elm, std::ostream &ostm,
			   aka::entity_complements &ecomp);
  };
  
  
}

#endif
