//CUPPA:include=+
//CUPPA:include=-
#include <cppunit/extensions/HelperMacros.h>
#include <cppunit/TestAssert.h>

//CUPPA:namespace=+
//CUPPA:namespace=-

#include <akaxiso2/akaxiso2.h>
#include <akaxiso2/unicode/uniconv.h>

class unicodeTest : public CppUnit::TestFixture {
  CPPUNIT_TEST_SUITE(unicodeTest);
//CUPPA:suite=+
  CPPUNIT_TEST(test_utf8);
//CUPPA:suite=-
  CPPUNIT_TEST_SUITE_END();
private:

  // your stuff...

public:

  virtual void setUp() { 
    aka::initialize();
  }
  virtual void tearDown() { 
    aka::uninitialize();
  }

//CUPPA:decl=+
  void test_utf8() {
    aka::uchar_t uch, uch1;
    char buffer[6];

    for (long num = 0; num < 65536; ++num) {
      uch = static_cast<aka::uchar_t>(num);
      size_t size  = aka::uniconv::ucs2_to_utf8(uch, buffer);
      char *bufend = buffer + size;
      size_t convsize = aka::uniconv::utf8_to_ucs2(buffer, bufend, &uch1);
      CPPUNIT_ASSERT_MESSAGE("size of converted string is not the same as original.", 
			     size == convsize);
      CPPUNIT_ASSERT_MESSAGE("wrong size.", size <= 3);
      CPPUNIT_ASSERT_MESSAGE("wrong conversion", uch == uch1);
    }

  }
//CUPPA:decl=-
};

//CUPPA:impl=+
//CUPPA:impl=-

CPPUNIT_TEST_SUITE_REGISTRATION(unicodeTest);
