//CUPPA:include=+
#include <akaxiso2/akaxiso2.h>
#include <akaxiso2/content_model.h>
//CUPPA:include=-
#include <cppunit/extensions/HelperMacros.h>
#include <cppunit/TestAssert.h>



//CUPPA:namespace=+
//CUPPA:namespace=-


namespace {

  struct seq1 {
    std::string value_;
  };

  typedef std::list<seq1> seq1array;

  struct seq {
    seq1array seq1_;
  };

  struct seq1_leaf : aka::sequence<seq1, seq1_leaf> {
    void model() {
      member("ns2:value", &seq1::value_);
    }
  }; 
  typedef aka2::sequential_array<seq1array, seq1_leaf> seq1array_leaf;

  struct seq_leaf : aka::sequence<seq, seq_leaf> {
    void model() {
      member("ns1:seq1", &seq::seq1_, seq1array_leaf(), 
	     0, aka2::unbounded);
    }
  }; 


  struct defns {
    std::string value_;
  };

  struct defns_leaf : aka::sequence<defns, defns_leaf> {
    void model() {
      member("ns1:seq1", &defns::value_);
    }
  }; 

  void initialize_() {
    aka2::initialize();
    aka2::xmlns("ns1", "testns1");
    aka2::xmlns("ns2", "testns2");
    aka2::doctype("test", seq_leaf());
    aka2::doctype("ns1:defns", defns_leaf());
  }

  void uninitialize_() {
    aka2::uninitialize();
  }
}


class namespaceTest : public CppUnit::TestFixture {
  CPPUNIT_TEST_SUITE(namespaceTest);
//CUPPA:suite=+
  CPPUNIT_TEST(test_ok);
  CPPUNIT_TEST(test_error);
  CPPUNIT_TEST(test_serialize_defns);
  CPPUNIT_TEST(test_deserialize_defns);
//CUPPA:suite=-
  CPPUNIT_TEST_SUITE_END();
private:

public:

  virtual void setUp() { 
    initialize_();
  }

  virtual void tearDown(){
    uninitialize_();
  }

//CUPPA:decl=+
  void test_deserialize_ok(const std::string &doc) {
    std::string err;
    try {
#ifdef USE_XERCESC
      aka2::xerces_deserializer xp;
      xp.deserialize(doc);
      aka::isstream xdocstm(doc);
      xp.deserialize(xdocstm);
#endif

      aka2::expat_deserializer ep;
      ep.deserialize(doc);
      aka::isstream edocstm(doc);
      ep.deserialize(edocstm);
    }
    catch ( const std::exception &e) {
      err = e.what();
    }
    CPPUNIT_ASSERT_MESSAGE("Failed to handle default namespace.", err.empty());
  }

  void test_deserialize_ng(const std::string &doc) {
    std::string err;

#ifdef USE_XERCESC
    try {
      aka2::xerces_deserializer xp;
      xp.deserialize(doc);
    }
    catch ( std::exception &e ) {
      err = e.what();
    }
    CPPUNIT_ASSERT_MESSAGE("xerces_deserializer failed to handle default namespace.", 
			   !err.empty());
#endif
    try {
      aka2::expat_deserializer ep;
      ep.deserialize(doc);
    }
    catch (const std::exception &e) {
      err = e.what();
    }
    CPPUNIT_ASSERT_MESSAGE("Failed to handle default namespace.", !err.empty());

  }

  void test_ok() {
    const char nested_def_ns[] = 
      "<?xml version=\"1.0\"?>"
      "<!-- test for nested default xmlns attribtes. -->"
      "<test>"
      "<seq1 xmlns=\"testns1\">"
      "<value xmlns=\"testns2\">test</value>"
      "</seq1>"
      "</test>";

    test_deserialize_ok(nested_def_ns);
  }

  void test_error() {
    const char nsdef_e0[] =
      "<?xml version=\"1.0\"?>"
      "<!-- test for nested default xmlns attribtes. -->"
      "<test>"
      "<seq1 xmlns:ns1=\"testns1\" xmlns=\"testns1\">"
      "<value xmlns:ns2=\"testns2\">test</value>"
      "</seq1>"
      "</test>";

    const char nsdef_e1[] =
      "<?xml version=\"1.0\"?>"
      "<!-- test for nested default xmlns attribtes. -->"
      "<test>"
      "<seq1 xmlns:ns1=\"testns1\" xmlns=\"testns1\">"
      "<ns2:value xmlns=\"testns2\">test</ns2:value>"
      "</seq1>"
      "</test>";

    const char nsdef_e2[] =
      "<?xml version=\"1.0\"?>"
      "<!-- test for nested default xmlns attribtes. -->"
      "<test>"
      "<seq1 xmlns:ns1=\"testns1\" xmlns:ns2=\"testns1\" "
      " ns2:attr=\"attr\" ns1:attr=\"attr\">"
      "</seq1>"
      "</test>";

    const char dup_attribute[] =
      "<?xml version=\"1.0\"?>"
      "<!-- test for nested default xmlns attribtes. -->"
      "<test>"
      "<seq1 xmlns:ns1=\"testns1\" xmlns:ns2=\"testns1\" "
      "ns2:attr=\"attr\" ns1:attr=\"attr\">"
      "</seq1>"
      "</test>";


    test_deserialize_ng(nsdef_e0);
    test_deserialize_ng(nsdef_e1);
    test_deserialize_ng(nsdef_e2);
    test_deserialize_ng(dup_attribute);
  }

  void test_serialize_defns() {
    std::ostringstream ostm;
    defns root;
    root.value_ = "value";
    aka::xml_serializer ser;
    ser.serialize(root, "ns1:defns", ostm);
  }


  void test_deserialize_defns() {
    const char *doc = 
      "<?xml version=\"1.0\" standalone=\"yes\"?>\n"
      "<defns xmlns=\"testns1\">\n"
      "  <seq1>value</seq1>\n"
      "</defns>\n";
    aka::deserialize(doc);
  }

//CUPPA:decl=-
};

//CUPPA:impl=+
//CUPPA:impl=-

CPPUNIT_TEST_SUITE_REGISTRATION(namespaceTest);
